"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigPanelManualAnnotation = void 0;
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _ = require("../..");
var _range_annotation_panel = require("./range_annotation_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ConfigPanelManualAnnotation = ({
  annotation,
  onChange,
  getDefaultRangeEnd,
  calendarClassName
}) => {
  const isRange = (0, _.isRangeAnnotationConfig)(annotation);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isRange ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_range_annotation_panel.ConfigPanelRangeDatePicker, {
    dataTestSubj: "lns-xyAnnotation-fromTime",
    calendarClassName: calendarClassName,
    prependLabel: _i18n.i18n.translate('eventAnnotation.xyChart.annotationDate.from', {
      defaultMessage: 'From'
    }),
    value: (0, _moment.default)(annotation === null || annotation === void 0 ? void 0 : annotation.key.timestamp),
    onChange: date => {
      if (date) {
        const currentEndTime = (0, _moment.default)(annotation === null || annotation === void 0 ? void 0 : annotation.key.endTimestamp).valueOf();
        if (currentEndTime < date.valueOf()) {
          const currentStartTime = (0, _moment.default)(annotation === null || annotation === void 0 ? void 0 : annotation.key.timestamp).valueOf();
          const dif = currentEndTime - currentStartTime;
          onChange({
            key: {
              ...((annotation === null || annotation === void 0 ? void 0 : annotation.key) || {
                type: 'range'
              }),
              timestamp: date.toISOString(),
              endTimestamp: (0, _moment.default)(date.valueOf() + dif).toISOString()
            }
          });
        } else {
          onChange({
            key: {
              ...((annotation === null || annotation === void 0 ? void 0 : annotation.key) || {
                type: 'range'
              }),
              timestamp: date.toISOString()
            }
          });
        }
      }
    },
    label: _i18n.i18n.translate('eventAnnotation.xyChart.annotationDate', {
      defaultMessage: 'Annotation date'
    })
  }), /*#__PURE__*/_react.default.createElement(_range_annotation_panel.ConfigPanelRangeDatePicker, {
    dataTestSubj: "lns-xyAnnotation-toTime",
    calendarClassName: calendarClassName,
    prependLabel: _i18n.i18n.translate('eventAnnotation.xyChart.annotationDate.to', {
      defaultMessage: 'To'
    }),
    value: (0, _moment.default)(annotation === null || annotation === void 0 ? void 0 : annotation.key.endTimestamp),
    onChange: date => {
      if (date) {
        const currentStartTime = (0, _moment.default)(annotation === null || annotation === void 0 ? void 0 : annotation.key.timestamp).valueOf();
        if (currentStartTime > date.valueOf()) {
          const currentEndTime = (0, _moment.default)(annotation === null || annotation === void 0 ? void 0 : annotation.key.endTimestamp).valueOf();
          const dif = currentEndTime - currentStartTime;
          onChange({
            key: {
              ...((annotation === null || annotation === void 0 ? void 0 : annotation.key) || {
                type: 'range'
              }),
              endTimestamp: date.toISOString(),
              timestamp: (0, _moment.default)(date.valueOf() - dif).toISOString()
            }
          });
        } else {
          onChange({
            key: {
              ...((annotation === null || annotation === void 0 ? void 0 : annotation.key) || {
                type: 'range'
              }),
              endTimestamp: date.toISOString()
            }
          });
        }
      }
    }
  })) : /*#__PURE__*/_react.default.createElement(_range_annotation_panel.ConfigPanelRangeDatePicker, {
    dataTestSubj: "lns-xyAnnotation-time",
    calendarClassName: calendarClassName,
    label: _i18n.i18n.translate('eventAnnotation.xyChart.annotationDate', {
      defaultMessage: 'Annotation date'
    }),
    value: (0, _moment.default)(annotation === null || annotation === void 0 ? void 0 : annotation.key.timestamp),
    onChange: date => {
      if (date) {
        onChange({
          key: {
            ...((annotation === null || annotation === void 0 ? void 0 : annotation.key) || {
              type: 'point_in_time'
            }),
            timestamp: date.toISOString()
          }
        });
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_range_annotation_panel.ConfigPanelApplyAsRangeSwitch, {
    annotation: annotation,
    onChange: onChange,
    getDefaultRangeEnd: getDefaultRangeEnd
  }));
};
exports.ConfigPanelManualAnnotation = ConfigPanelManualAnnotation;