"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.idPrefix = exports.default = void 0;
require("./index.scss");
var _public = require("@kbn/visualization-ui-components/public");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public2 = require("@kbn/unified-field-list-plugin/public");
var _moment = _interopRequireDefault(require("moment"));
var _ = require("../..");
var _helpers = require("./helpers");
var _icon_set = require("./icon_set");
var _tooltip_annotation_panel = require("./tooltip_annotation_panel");
var _manual_annotation_panel = require("./manual_annotation_panel");
var _query_annotation_panel = require("./query_annotation_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const idPrefix = (0, _eui.htmlIdGenerator)()();
exports.idPrefix = idPrefix;
const AnnotationEditorControls = ({
  annotation: currentAnnotation,
  onAnnotationChange,
  dataView,
  getDefaultRangeEnd,
  calendarClassName,
  queryInputServices,
  appName
}) => {
  const {
    hasFieldData
  } = (0, _public2.useExistingFieldsReader)();
  const isQueryBased = (0, _.isQueryAnnotationConfig)(currentAnnotation);
  const isRange = (0, _.isRangeAnnotationConfig)(currentAnnotation);
  const [queryInputShouldOpen, setQueryInputShouldOpen] = _react.default.useState(false);
  (0, _react.useEffect)(() => {
    setQueryInputShouldOpen(!isQueryBased);
  }, [isQueryBased]);
  const update = (0, _react.useCallback)(newAnnotation => newAnnotation && onAnnotationChange((0, _helpers.sanitizeProperties)({
    ...currentAnnotation,
    ...newAnnotation
  })), [currentAnnotation, onAnnotationChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.DimensionEditorSection, {
    title: _i18n.i18n.translate('eventAnnotation.xyChart.placement', {
      defaultMessage: 'Placement'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('eventAnnotation.xyChart.annotationDate.placementType', {
      defaultMessage: 'Placement type'
    }),
    display: "rowCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('eventAnnotation.xyChart.annotationDate.placementType', {
      defaultMessage: 'Placement type'
    }),
    "data-test-subj": "lns-xyAnnotation-placementType",
    name: "placementType",
    buttonSize: "compressed",
    options: [{
      id: `lens_xyChart_annotation_manual`,
      label: _i18n.i18n.translate('eventAnnotation.xyChart.annotation.manual', {
        defaultMessage: 'Static date'
      }),
      'data-test-subj': 'lnsXY_annotation_manual'
    }, {
      id: `lens_xyChart_annotation_query`,
      label: _i18n.i18n.translate('eventAnnotation.xyChart.annotation.query', {
        defaultMessage: 'Custom query'
      }),
      'data-test-subj': 'lnsXY_annotation_query'
    }],
    idSelected: `lens_xyChart_annotation_${currentAnnotation === null || currentAnnotation === void 0 ? void 0 : currentAnnotation.type}`,
    onChange: id => {
      const typeFromId = id.replace('lens_xyChart_annotation_', '');
      if ((currentAnnotation === null || currentAnnotation === void 0 ? void 0 : currentAnnotation.type) === typeFromId) {
        return;
      }
      if (typeFromId === 'query') {
        var _ref, _dataView$fields$filt;
        // If coming from a range type, it requires some additional resets
        const additionalRangeResets = (0, _.isRangeAnnotationConfig)(currentAnnotation) ? {
          label: currentAnnotation.label === _helpers.defaultRangeAnnotationLabel ? _helpers.defaultAnnotationLabel : currentAnnotation.label,
          color: (0, _helpers.toLineAnnotationColor)(currentAnnotation.color)
        } : {};
        return update({
          type: typeFromId,
          timeField: (_ref = dataView.timeFieldName || ( // fallback to the first avaiable date field in the dataView
          (_dataView$fields$filt = dataView.fields.filter(_public.isFieldLensCompatible).find(({
            type: fieldType
          }) => fieldType === 'date')) === null || _dataView$fields$filt === void 0 ? void 0 : _dataView$fields$filt.displayName)) !== null && _ref !== void 0 ? _ref : '',
          key: {
            type: 'point_in_time'
          },
          ...additionalRangeResets
        });
      }
      // From query to manual annotation
      return update({
        type: typeFromId,
        key: {
          type: 'point_in_time',
          timestamp: (0, _moment.default)().toISOString()
        }
      });
    },
    isFullWidth: true
  })), isQueryBased ? /*#__PURE__*/_react.default.createElement(_query_annotation_panel.ConfigPanelQueryAnnotation, {
    annotation: currentAnnotation,
    onChange: update,
    dataView: dataView,
    queryInputShouldOpen: queryInputShouldOpen,
    queryInputServices: queryInputServices,
    appName: appName
  }) : /*#__PURE__*/_react.default.createElement(_manual_annotation_panel.ConfigPanelManualAnnotation, {
    annotation: currentAnnotation,
    onChange: update,
    getDefaultRangeEnd: getDefaultRangeEnd,
    calendarClassName: calendarClassName
  })), /*#__PURE__*/_react.default.createElement(_public.DimensionEditorSection, {
    title: _i18n.i18n.translate('eventAnnotation.xyChart.appearance', {
      defaultMessage: 'Appearance'
    })
  }, /*#__PURE__*/_react.default.createElement(_public.NameInput, {
    value: (currentAnnotation === null || currentAnnotation === void 0 ? void 0 : currentAnnotation.label) || _helpers.defaultAnnotationLabel,
    defaultValue: _helpers.defaultAnnotationLabel,
    onChange: value => {
      update({
        label: value
      });
    }
  }), !isRange && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.IconSelectSetting, {
    currentIcon: currentAnnotation.icon,
    setIcon: icon => update({
      icon
    }),
    defaultIcon: "triangle",
    customIconSet: _icon_set.annotationsIconSet
  }), /*#__PURE__*/_react.default.createElement(_public.TextDecorationSetting, {
    idPrefix: idPrefix,
    setConfig: update,
    currentConfig: currentAnnotation,
    isQueryBased: isQueryBased
  }, textDecorationSelected => {
    if (textDecorationSelected !== 'field') {
      return null;
    }
    const options = dataView.fields.filter(_public.isFieldLensCompatible).filter(({
      displayName,
      type
    }) => displayName && type !== 'document').map(field => ({
      label: field.displayName,
      value: {
        type: 'field',
        field: field.name,
        dataType: field.type
      },
      exists: hasFieldData(dataView.id, field.name),
      compatible: true,
      'data-test-subj': `lnsXY-annotation-fieldOption-${field.name}`
    }));
    const selectedField = currentAnnotation.textField;
    const fieldIsValid = selectedField ? Boolean(dataView.getFieldByName(selectedField)) : true;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_public.FieldPicker, {
      selectedOptions: selectedField ? [{
        label: selectedField,
        value: {
          type: 'field',
          field: selectedField
        }
      }] : [],
      options: options,
      onChoose: function (choice) {
        if (choice) {
          update({
            textField: choice.field,
            textVisibility: true
          });
        }
      },
      fieldIsInvalid: !fieldIsValid,
      "data-test-subj": "lnsXY-annotation-query-based-text-decoration-field-picker",
      autoFocus: !selectedField
    }));
  }), /*#__PURE__*/_react.default.createElement(_public.LineStyleSettings, {
    idPrefix: idPrefix,
    setConfig: update,
    currentConfig: {
      lineStyle: currentAnnotation.lineStyle,
      lineWidth: currentAnnotation.lineWidth
    }
  })), isRange && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('eventAnnotation.xyChart.fillStyle', {
      defaultMessage: 'Fill'
    }),
    display: "columnCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('eventAnnotation.xyChart.fillStyle', {
      defaultMessage: 'Fill'
    }),
    "data-test-subj": "lns-xyAnnotation-fillStyle",
    name: "fillStyle",
    buttonSize: "compressed",
    options: [{
      id: `lens_xyChart_fillStyle_inside`,
      label: _i18n.i18n.translate('eventAnnotation.xyChart.fillStyle.inside', {
        defaultMessage: 'Inside'
      }),
      'data-test-subj': 'lnsXY_fillStyle_inside'
    }, {
      id: `lens_xyChart_fillStyle_outside`,
      label: _i18n.i18n.translate('eventAnnotation.xyChart.fillStyle.outside', {
        defaultMessage: 'Outside'
      }),
      'data-test-subj': 'lnsXY_fillStyle_inside'
    }],
    idSelected: `lens_xyChart_fillStyle_${Boolean(currentAnnotation === null || currentAnnotation === void 0 ? void 0 : currentAnnotation.outside) ? 'outside' : 'inside'}`,
    onChange: id => {
      update({
        outside: id === `lens_xyChart_fillStyle_outside`
      });
    },
    isFullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_public.ColorPicker, {
    overwriteColor: currentAnnotation.color,
    defaultColor: isRange ? _helpers.defaultAnnotationRangeColor : _helpers.defaultAnnotationColor,
    showAlpha: isRange,
    setConfig: update,
    disableHelpTooltip: true,
    label: _i18n.i18n.translate('eventAnnotation.xyChart.lineColor.label', {
      defaultMessage: 'Color'
    })
  }), /*#__PURE__*/_react.default.createElement(ConfigPanelGenericSwitch, {
    label: _i18n.i18n.translate('eventAnnotation.xyChart.annotation.hide', {
      defaultMessage: 'Hide annotation'
    }),
    "data-test-subj": "lns-annotations-hide-annotation",
    value: Boolean(currentAnnotation.isHidden),
    onChange: ev => update({
      isHidden: ev.target.checked
    })
  })), isQueryBased && currentAnnotation && /*#__PURE__*/_react.default.createElement(_public.DimensionEditorSection, {
    title: _i18n.i18n.translate('eventAnnotation.xyChart.tooltip', {
      defaultMessage: 'Tooltip'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    className: "lnsRowCompressedMargin",
    fullWidth: true,
    label: _i18n.i18n.translate('eventAnnotation.xyChart.annotation.tooltip', {
      defaultMessage: 'Show additional fields'
    })
  }, /*#__PURE__*/_react.default.createElement(_tooltip_annotation_panel.TooltipSection, {
    currentConfig: currentAnnotation,
    setConfig: update,
    dataView: dataView
  }))));
};
const ConfigPanelGenericSwitch = ({
  label,
  ['data-test-subj']: dataTestSubj,
  value,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  label: label,
  display: "columnCompressedSwitch",
  fullWidth: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
  compressed: true,
  label: label,
  showLabel: false,
  "data-test-subj": dataTestSubj,
  checked: value,
  onChange: onChange
}));

// eslint-disable-next-line import/no-default-export
var _default = AnnotationEditorControls;
exports.default = _default;