"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startConnectorSync = void 0;
var _ = require("../..");
var _is_category_entry = require("../../../common/connectors/is_category_entry");
var _constants = require("../../../common/constants");
var _connectors = require("../../../common/types/connectors");
var _error_codes = require("../../../common/types/error_codes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const startConnectorSync = async (client, connectorId, jobType, nextSyncConfig) => {
  const connectorResult = await client.asCurrentUser.get({
    id: connectorId,
    index: _.CONNECTORS_INDEX
  });
  const connector = connectorResult._source;
  if (connector) {
    var _filtering$0$active, _filtering$;
    const config = Object.entries(connector.configuration).reduce((acc, [key, configEntry]) => {
      if ((0, _is_category_entry.isConfigEntry)(configEntry)) {
        acc[key] = configEntry;
      }
      return acc;
    }, {});
    const configuration = nextSyncConfig ? {
      ...config,
      nextSyncConfig: {
        label: 'nextSyncConfig',
        value: nextSyncConfig
      }
    } : config;
    const {
      filtering,
      index_name,
      language,
      pipeline,
      service_type
    } = connector;
    const now = new Date().toISOString();
    if (connector.service_type === _constants.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE) {
      return await client.asCurrentUser.update({
        doc: {
          configuration,
          sync_now: true
        },
        id: connectorId,
        if_primary_term: connectorResult._primary_term,
        if_seq_no: connectorResult._seq_no,
        index: _.CONNECTORS_INDEX
      });
    }
    const indexNameWithoutSearchPrefix = index_name.replace('search-', '');
    const targetIndexName = jobType === _connectors.SyncJobType.ACCESS_CONTROL ? `${_constants.CONNECTORS_ACCESS_CONTROL_INDEX_PREFIX}${indexNameWithoutSearchPrefix}` : index_name;
    return await client.asCurrentUser.index({
      document: {
        cancelation_requested_at: null,
        canceled_at: null,
        completed_at: null,
        connector: {
          configuration,
          filtering: filtering ? (_filtering$0$active = (_filtering$ = filtering[0]) === null || _filtering$ === void 0 ? void 0 : _filtering$.active) !== null && _filtering$0$active !== void 0 ? _filtering$0$active : null : null,
          id: connectorId,
          index_name: targetIndexName,
          language,
          pipeline: pipeline !== null && pipeline !== void 0 ? pipeline : null,
          service_type
        },
        created_at: now,
        deleted_document_count: 0,
        error: null,
        indexed_document_count: 0,
        indexed_document_volume: 0,
        job_type: jobType,
        last_seen: null,
        metadata: {},
        started_at: null,
        status: _connectors.SyncStatus.PENDING,
        total_document_count: null,
        trigger_method: _connectors.TriggerMethod.ON_DEMAND,
        worker_hostname: null
      },
      index: _.CONNECTORS_JOBS_INDEX
    });
  } else {
    throw new Error(_error_codes.ErrorCode.RESOURCE_NOT_FOUND);
  }
};
exports.startConnectorSync = startConnectorSync;