"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureOauth = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _loading = require("../../../../../shared/loading");
var _add_source_logic = require("./add_source_logic");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigureOauth = ({
  name,
  onFormCreated,
  header
}) => {
  const [formLoading, setFormLoading] = (0, _react.useState)(false);
  const {
    getPreContentSourceConfigData,
    setSelectedGithubOrganizations,
    createContentSource
  } = (0, _kea.useActions)(_add_source_logic.AddSourceLogic);
  const {
    githubOrganizations,
    selectedGithubOrganizationsMap,
    sectionLoading
  } = (0, _kea.useValues)(_add_source_logic.AddSourceLogic);
  const checkboxOptions = githubOrganizations.map(item => ({
    id: item,
    label: item
  }));
  (0, _react.useEffect)(() => {
    getPreContentSourceConfigData();
  }, []);
  const handleChange = option => setSelectedGithubOrganizations(option);
  const formSubmitSuccess = () => onFormCreated(name);
  const handleFormSubmitError = () => setFormLoading(false);
  const handleFormSubmit = e => {
    setFormLoading(true);
    e.preventDefault();
    createContentSource(formSubmitSuccess, handleFormSubmitError);
  };
  const configfieldsForm = /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: handleFormSubmit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "flexStart",
    justifyContent: "spaceBetween",
    gutterSize: "xl",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    className: "adding-a-source__connect-an-instance"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.CONFIG_OAUTH_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckboxGroup, {
    options: checkboxOptions,
    idToSelectedMap: selectedGithubOrganizationsMap,
    onChange: handleChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: formLoading,
    color: "primary",
    fill: true,
    type: "submit"
  }, _constants.CONFIG_OAUTH_BUTTON)))));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, header, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), sectionLoading ? /*#__PURE__*/_react.default.createElement(_loading.Loading, null) : configfieldsForm);
};
exports.ConfigureOauth = ConfigureOauth;