"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateReactRouterProps = void 0;
var _http = require("../http");
var _kibana = require("../kibana");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateReactRouterProps = ({
  to,
  onClick,
  shouldNotCreateHref = false
}) => {
  const {
    navigateToUrl,
    history
  } = _kibana.KibanaLogic.values;
  const {
    http
  } = _http.HttpLogic.values;

  // Generate the correct link href (with basename etc. accounted for)
  const href = (0, _.createHref)(to, {
    history,
    http
  }, {
    shouldNotCreateHref
  });
  const reactRouterLinkClick = event => {
    if (onClick) onClick(); // Run any passed click events (e.g. telemetry)
    if ((0, _.letBrowserHandleEvent)(event)) return; // Return early if the link behavior shouldn't be handled by React Router

    // Prevent regular link behavior, which causes a browser refresh.
    event.preventDefault();

    // Perform SPA navigation.
    navigateToUrl(to, {
      shouldNotCreateHref
    });
  };
  return {
    href,
    onClick: reactRouterLinkClick
  };
};
exports.generateReactRouterProps = generateReactRouterProps;