"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountLicensingLogic = exports.LicensingLogic = void 0;
var _kea = require("kea");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LicensingLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'licensing_logic'],
  actions: {
    setLicense: license => license,
    setLicenseSubscription: licenseSubscription => licenseSubscription
  },
  reducers: ({
    props
  }) => ({
    license: [null, {
      setLicense: (_, license) => license
    }],
    licenseSubscription: [null, {
      setLicenseSubscription: (_, licenseSubscription) => licenseSubscription
    }],
    canManageLicense: [props.canManageLicense || false, {}]
  }),
  selectors: {
    hasPlatinumLicense: [selectors => [selectors.license], license => {
      const qualifyingLicenses = ['platinum', 'enterprise', 'trial'];
      return (license === null || license === void 0 ? void 0 : license.isActive) && qualifyingLicenses.includes(license === null || license === void 0 ? void 0 : license.type);
    }],
    hasGoldLicense: [selectors => [selectors.license], license => {
      const qualifyingLicenses = ['gold', 'platinum', 'enterprise', 'trial'];
      return (license === null || license === void 0 ? void 0 : license.isActive) && qualifyingLicenses.includes(license === null || license === void 0 ? void 0 : license.type);
    }],
    isTrial: [selectors => [selectors.license], license => (license === null || license === void 0 ? void 0 : license.isActive) && (license === null || license === void 0 ? void 0 : license.type) === 'trial']
  },
  events: ({
    props,
    actions,
    values
  }) => ({
    afterMount: () => {
      const licenseSubscription = props.license$.subscribe(async license => {
        actions.setLicense(license);
      });
      actions.setLicenseSubscription(licenseSubscription);
    },
    beforeUnmount: () => {
      if (values.licenseSubscription) values.licenseSubscription.unsubscribe();
    }
  })
});

/**
 * Mount/props helper
 */
exports.LicensingLogic = LicensingLogic;
const mountLicensingLogic = props => {
  LicensingLogic(props);
  const unmount = LicensingLogic.mount();
  return unmount;
};
exports.mountLicensingLogic = mountLicensingLogic;