"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchEsrePageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../../common/constants");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _layout = require("../../../shared/layout");
var _telemetry = require("../../../shared/telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnterpriseSearchEsrePageTemplate = ({
  children,
  pageChrome,
  pageViewTelemetry,
  ...pageTemplateProps
}) => {
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchPageTemplateWrapper, (0, _extends2.default)({}, pageTemplateProps, {
    solutionNav: {
      name: _constants.ESRE_PLUGIN.NAME,
      items: (0, _layout.useEnterpriseSearchNav)()
    },
    setPageChrome: pageChrome && /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetEsreChrome, {
      trail: pageChrome
    })
  }), pageViewTelemetry && /*#__PURE__*/_react.default.createElement(_telemetry.SendEnterpriseSearchTelemetry, {
    action: "viewed",
    metric: pageViewTelemetry
  }), children);
};
exports.EnterpriseSearchEsrePageTemplate = EnterpriseSearchEsrePageTemplate;