"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinearCombinationPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _routes = require("../../../enterprise_search_content/routes");
var _doc_links = require("../../../shared/doc_links");
var _react_router_helpers = require("../../../shared/react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const steps = [{
  title: _i18n.i18n.translate('xpack.enterpriseSearch.esre.linearCombinationPanel.step1.title', {
    defaultMessage: 'Discover how to use linear combination in _search queries'
  }),
  children: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-telemetry-id": "entSearch-esre-rankAggregation-linearCombinationPanel-knnSearchCombineLink",
    href: _doc_links.docLinks.knnSearchCombine,
    target: "_blank",
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.esre.linearCombinationPanel.step1.knnSearchCombineLinkText', {
    defaultMessage: 'Combine approximate kNN with other features'
  })),
  status: 'incomplete'
}, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.esre.linearCombinationPanel.step2.title', {
    defaultMessage: 'Try it today in Console'
  }),
  children: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    "data-telemetry-id": "entSearch-esre-rankAggregation-linearCombinationPanel-devToolsConsoleButton",
    to: (0, _reactRouterDom.generatePath)(_routes.DEV_TOOLS_CONSOLE_PATH),
    shouldNotCreateHref: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, null, _i18n.i18n.translate('xpack.enterpriseSearch.esre.linearCombinationPanel.step2.buttonLabel', {
    defaultMessage: 'Open Console'
  }))),
  status: 'incomplete'
}];
const LinearCombinationPanel = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.esre.linearCombinationPanel.description",
  defaultMessage: "Used to calculate a similarity score or distance between data points. Combines attributes or features using weights, which enables customized relevance factors."
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
  steps: steps,
  titleSize: "xs"
}))));
exports.LinearCombinationPanel = LinearCombinationPanel;