"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsreGuide = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _analytics = _interopRequireDefault(require("../../../../assets/images/analytics.svg"));
var _scalable = _interopRequireDefault(require("../../../../assets/images/scalable.svg"));
var _simplify = _interopRequireDefault(require("../../../../assets/images/simplify.svg"));
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _page_template = require("../layout/page_template");
var _esre_docs_section = require("./esre_docs_section");
var _measure_performance_section = require("./measure_performance_section");
var _rank_aggregation_section = require("./rank_aggregation_section");
var _semantic_search_section = require("./semantic_search_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EsreGuide = () => {
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs']);
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchEsrePageTemplate, {
    restrictWidth: true,
    bottomBorder: false,
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.esre.guide.pageTitle', {
        defaultMessage: 'Enhance your search with ESRE'
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetEsreChrome, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "column",
    responsive: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    alignItems: "center",
    responsive: false,
    columns: isMobile ? 1 : 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "m",
    src: _simplify.default,
    alt: ""
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "m",
    src: _analytics.default,
    alt: ""
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "m",
    src: _scalable.default,
    alt: ""
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.esre.guide.description",
    defaultMessage: "The Elasticsearch Relevance Engine\u2122 (ESRE) enables developers to build AI search-powered applications using the Elastic platform. ESRE is a set of tools and features that include our proprietary trained ML model ELSER, our vector search and embeddings capabilities, and RRF ranking for combining vector and text search."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_semantic_search_section.SemanticSearchSection, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_rank_aggregation_section.RankAggregationSection, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_measure_performance_section.MeasurePerformanceSection, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_esre_docs_section.EsreDocsSection, null)))));
};
exports.EsreGuide = EsreGuide;