"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsreDocsSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../shared/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EsreDocsSection = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 4
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.esre.esreDocsSection.title",
  defaultMessage: "Dive deeper with the ESRE docs"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.esre.esreDocsSection.description",
  defaultMessage: "To learn more about how to get started with ESRE, and test these tools with concrete examples, visit the {esreDocumentation}.",
  values: {
    esreDocumentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-telemetry-id": "entSearch-esre-documentation-esreHomeLink",
      target: "_blank",
      href: _doc_links.docLinks.esre,
      external: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.esre.esreDocsSection.description.esreLinkText', {
      defaultMessage: 'ESRE documentation'
    }))
  }
})))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 6
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  hasBorder: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.esre.esreDocsSection.learn.title",
  defaultMessage: "Learn"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.esre.esreDocsSection.learn.description",
  defaultMessage: "These are complex subjects, so we've curated some {learningTopics} to help you get started.",
  values: {
    learningTopics: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-telemetry-id": "entSearch-esre-documentation-esreLearnLink",
      target: "_blank",
      href: _doc_links.docLinks.esreLearn,
      external: false
    }, _i18n.i18n.translate('xpack.enterpriseSearch.esre.esreDocsSection.learn.learningTopicsLinkText', {
      defaultMessage: 'learning topics'
    }))
  }
}))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  hasBorder: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.esre.esreDocsSection.faq.title",
  defaultMessage: "FAQ"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.esre.esreDocsSection.faq.description",
  defaultMessage: "Learn what ESRE is (and isn't) from these {frequentlyAskedQuestions}.",
  values: {
    frequentlyAskedQuestions: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-telemetry-id": "entSearch-esre-documentation-esreFaqLink",
      target: "_blank",
      href: _doc_links.docLinks.esreFaq,
      external: false
    }, _i18n.i18n.translate('xpack.enterpriseSearch.esre.esreDocsSection.learn.frequentlyAskedQuestionsLinkText', {
      defaultMessage: 'frequently asked questions'
    }))
  }
}))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  hasBorder: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.esre.esreDocsSection.help.title",
  defaultMessage: "Help"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.esre.esreDocsSection.help.description",
  defaultMessage: "Need help? Check out the {discussForum}!",
  values: {
    discussForum: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-telemetry-id": "entSearch-esre-documentation-esreHelpLink",
      target: "_blank",
      href: _doc_links.docLinks.esreHelp,
      external: false
    }, _i18n.i18n.translate('xpack.enterpriseSearch.esre.esreDocsSection.learn.discussForumLinkText', {
      defaultMessage: 'ESRE discuss forum'
    }))
  }
}))))))))));
exports.EsreDocsSection = EsreDocsSection;