"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlatinumLicensePopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../../../../shared/doc_links");
var _kibana = require("../../../../shared/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PlatinumLicensePopover = ({
  button,
  isPopoverOpen,
  closePopover
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.selectConnector.upgradeTitle', {
    defaultMessage: 'Upgrade to Elastic Platinum'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    size: "s",
    css: (0, _react2.css)`
          max-width: calc(${euiTheme.size.xl} * 10);
        `
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.selectConnector.upgradeContent', {
    defaultMessage: 'To use this connector, you must update your license to Platinum or start a 30-day free trial.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "popout",
    target: "_blank",
    href: _doc_links.docLinks.licenseManagement
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.selectConnector.subscriptionButtonLabel', {
    defaultMessage: 'Subscription plans'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "wrench",
    iconSide: "right",
    onClick: () => _kibana.KibanaLogic.values.navigateToUrl('/app/management/stack/license_management', {
      shouldNotCreateHref: true
    })
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.selectConnector.manageLicenseButtonLabel', {
    defaultMessage: 'Manage license'
  }))))));
};
exports.PlatinumLicensePopover = PlatinumLicensePopover;