"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncJobsHistoryTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _formatted_date_time = require("../../../../shared/formatted_date_time");
var _page_to_pagination = require("../../../../shared/pagination/page_to_pagination");
var _duration_to_text = require("../../../utils/duration_to_text");
var _sync_status_to_text = require("../../../utils/sync_status_to_text");
var _index_view_logic = require("../index_view_logic");
var _sync_job_flyout = require("./sync_job_flyout");
var _sync_jobs_view_logic = require("./sync_jobs_view_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyncJobsHistoryTable = ({
  type
}) => {
  const {
    connectorId
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    fetchSyncJobs
  } = (0, _kea.useActions)(_sync_jobs_view_logic.SyncJobsViewLogic);
  const {
    syncJobs,
    syncJobsLoading,
    syncJobsPagination
  } = (0, _kea.useValues)(_sync_jobs_view_logic.SyncJobsViewLogic);
  const [syncJobFlyout, setSyncJobFlyout] = (0, _react.useState)(undefined);
  const columns = [{
    field: 'lastSync',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.syncJobs.lastSync.columnTitle', {
      defaultMessage: 'Last sync'
    }),
    render: lastSync => /*#__PURE__*/_react.default.createElement(_formatted_date_time.FormattedDateTime, {
      date: new Date(lastSync)
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'duration',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.syncJobs.syncDuration.columnTitle', {
      defaultMessage: 'Sync duration'
    }),
    render: duration => (0, _duration_to_text.durationToText)(duration),
    sortable: true,
    truncateText: true
  }, ...(type === 'content' ? [{
    field: 'indexed_document_count',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.addedDocs.columnTitle', {
      defaultMessage: 'Docs added'
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'deleted_document_count',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.deletedDocs.columnTitle', {
      defaultMessage: 'Docs deleted'
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'job_type',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.syncJobType.columnTitle', {
      defaultMessage: 'Content sync type'
    }),
    render: syncType => {
      const syncJobTypeText = (0, _sync_status_to_text.syncJobTypeToText)(syncType);
      if (syncJobTypeText.length === 0) return null;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, syncJobTypeText);
    },
    sortable: true,
    truncateText: true
  }] : []), ...(type === 'access_control' ? [{
    field: 'indexed_document_count',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.identitySync.columnTitle', {
      defaultMessage: 'Identities synced'
    }),
    sortable: true,
    truncateText: true
  }] : []), {
    field: 'status',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.syncStatus.columnTitle', {
      defaultMessage: 'Status'
    }),
    render: syncStatus => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: (0, _sync_status_to_text.syncStatusToColor)(syncStatus)
    }, (0, _sync_status_to_text.syncStatusToText)(syncStatus)),
    truncateText: true
  }, {
    actions: [{
      description: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.actions.viewJob.title', {
        defaultMessage: 'View this sync job'
      }),
      icon: 'eye',
      isPrimary: false,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.actions.viewJob.caption', {
        defaultMessage: 'View this sync job'
      }),
      onClick: job => setSyncJobFlyout(job),
      type: 'icon'
    }]
  }];
  (0, _react.useEffect)(() => {
    if (connectorId) {
      var _syncJobsPagination$f, _syncJobsPagination$s;
      fetchSyncJobs({
        connectorId,
        from: (_syncJobsPagination$f = syncJobsPagination.from) !== null && _syncJobsPagination$f !== void 0 ? _syncJobsPagination$f : 0,
        size: (_syncJobsPagination$s = syncJobsPagination.size) !== null && _syncJobsPagination$s !== void 0 ? _syncJobsPagination$s : 10,
        type
      });
    }
  }, [connectorId, type]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sync_job_flyout.SyncJobFlyout, {
    onClose: () => setSyncJobFlyout(undefined),
    syncJob: syncJobFlyout
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": `entSearchContent-index-${type}-syncJobs-table`,
    items: syncJobs,
    columns: columns,
    hasActions: true,
    onChange: ({
      page: {
        index,
        size
      }
    }) => {
      if (connectorId) {
        fetchSyncJobs({
          connectorId,
          from: index * size,
          size,
          type
        });
      }
    },
    pagination: (0, _page_to_pagination.pageToPagination)(syncJobsPagination),
    tableLayout: "fixed",
    loading: syncJobsLoading
  }));
};
exports.SyncJobsHistoryTable = SyncJobsHistoryTable;