"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchIndicesNav = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _encode_path_params = require("../../../shared/encode_path_params");
var _layout = require("../../../shared/layout");
var _routes = require("../../routes");
require("./index_nav.scss");
var _search_index = require("./search_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: We need to write tests for this once we have a logic file in place and a functioning API.

const useSearchIndicesNav = () => {
  const isIndexRoute = !!(0, _reactRouterDom.useRouteMatch)(_routes.SEARCH_INDEX_PATH);
  const {
    indexName
  } = (0, _reactRouterDom.useParams)();
  if (!indexName || !isIndexRoute) return undefined;
  const navItems = [{
    'data-test-subj': 'IndexLabel',
    id: 'indexName',
    name: indexName,
    renderItem: () => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      className: "enterpriseSearchNavIndexLabel"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-textTruncate"
    }, indexName.toUpperCase()))
  }, {
    'data-test-subj': 'IndexOverviewLink',
    id: _search_index.SearchIndexTabId.OVERVIEW,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.nav.overviewTitle', {
      defaultMessage: 'Overview'
    }),
    ...(0, _layout.generateNavLink)({
      to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
        indexName,
        tabId: _search_index.SearchIndexTabId.OVERVIEW
      })
    })
  }, {
    'data-test-subj': 'IndexDocumentsLink',
    id: _search_index.SearchIndexTabId.DOCUMENTS,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.nav.documentsTitle', {
      defaultMessage: 'Documents'
    }),
    ...(0, _layout.generateNavLink)({
      to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
        indexName,
        tabId: _search_index.SearchIndexTabId.DOCUMENTS
      })
    })
  }, {
    'data-test-subj': 'IndexIndexMappingsLink',
    id: _search_index.SearchIndexTabId.INDEX_MAPPINGS,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.nav.indexMappingsTitle', {
      defaultMessage: 'Index Mappings'
    }),
    ...(0, _layout.generateNavLink)({
      to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
        indexName,
        tabId: _search_index.SearchIndexTabId.INDEX_MAPPINGS
      })
    })
  }];
  return navItems;
};
exports.useSearchIndicesNav = useSearchIndicesNav;