"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenerateApiKeyPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../shared/doc_links");
var _constants = require("../new_index/constants");
var _settings_logic = require("../settings/settings_logic");
var _popover = require("./components/client_libraries_popover/popover");
var _curl_request = require("./components/curl_request/curl_request");
var _modal = require("./components/generate_api_key_modal/modal");
var _popover2 = require("./components/manage_api_keys_popover/popover");
var _index_view_logic = require("./index_view_logic");
var _overview = require("./overview.logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GenerateApiKeyPanel = () => {
  const {
    apiKey,
    isGenerateModalOpen
  } = (0, _kea.useValues)(_overview.OverviewLogic);
  const {
    indexName,
    ingestionMethod,
    isHiddenIndex
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    closeGenerateModal
  } = (0, _kea.useActions)(_overview.OverviewLogic);
  const {
    defaultPipeline
  } = (0, _kea.useValues)(_settings_logic.SettingsLogic);
  const [optimizedRequest, setOptimizedRequest] = (0, _react.useState)(true);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isGenerateModalOpen && /*#__PURE__*/_react.default.createElement(_modal.GenerateApiKeyModal, {
    indexName: indexName,
    onClose: closeGenerateModal
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, isHiddenIndex ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.emptyPrompt.body', {
      defaultMessage: 'We do not recommend adding documents to an externally managed index.'
    })),
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.emptyPrompt.title', {
      defaultMessage: 'Index managed externally'
    }))
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documentExample.title', {
    defaultMessage: 'Adding documents to your index'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.overview.documentExample.description.text",
    defaultMessage: "Generate an API key and read the {documentation} on how to send documents to the Elasticsearch API endpoint. Use Elastic  {clients} for streamlined integration.",
    values: {
      clients: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.clientsGuide,
        external: true
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documentExample.description.clientsLink', {
        defaultMessage: 'programming language clients'
      })),
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.indexApi,
        external: true
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documentExample.description.documentationLink', {
        defaultMessage: 'documentation'
      }))
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_popover.ClientLibrariesPopover, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_popover2.ManageKeysPopover, null)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-overview-generateApiKey-optimizedRequest`,
    onChange: event => setOptimizedRequest(event.target.checked),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.optimizedRequest.label', {
      defaultMessage: 'View Enterprise Search optimized request'
    }),
    checked: optimizedRequest
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_curl_request.CurlRequest, {
    apiKey: apiKey,
    document: _constants.DOCUMENTS_API_JSON_EXAMPLE,
    indexName: indexName,
    pipeline: optimizedRequest ? defaultPipeline : undefined
  })))))));
};
exports.GenerateApiKeyPanel = GenerateApiKeyPanel;