"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexDocuments = exports.INDEX_DOCUMENTS_META_DEFAULT = exports.DEFAULT_PAGINATION = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _api = require("../../../../../common/types/api");
var _constants2 = require("../../../shared/constants");
var _kibana = require("../../../shared/kibana");
var _mappings_logic = require("../../api/mappings/mappings_logic");
var _search_documents_api_logic = require("../../api/search_documents/search_documents_api_logic");
var _access_control_index_selector = require("./components/access_control_index_selector/access_control_index_selector");
var _document_list = require("./components/document_list/document_list");
var _index_name_logic = require("./index_name_logic");
var _index_view_logic = require("./index_view_logic");
require("./documents.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDEX_DOCUMENTS_META_DEFAULT = {
  page: {
    current: 0,
    size: _constants.ENTERPRISE_SEARCH_DOCUMENTS_DEFAULT_DOC_COUNT,
    total_pages: 0,
    total_results: 0
  }
};
exports.INDEX_DOCUMENTS_META_DEFAULT = INDEX_DOCUMENTS_META_DEFAULT;
const DEFAULT_PAGINATION = {
  pageIndex: INDEX_DOCUMENTS_META_DEFAULT.page.current,
  pageSize: INDEX_DOCUMENTS_META_DEFAULT.page.size,
  totalItemCount: INDEX_DOCUMENTS_META_DEFAULT.page.total_results
};
exports.DEFAULT_PAGINATION = DEFAULT_PAGINATION;
const SearchIndexDocuments = () => {
  var _data$results$hits$hi, _data$results, _mappingData$mappings, _mappingData$mappings2, _data$meta;
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    ingestionMethod,
    hasDocumentLevelSecurityFeature
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    productFeatures
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const [selectedIndexType, setSelectedIndexType] = (0, _react.useState)('content-index');
  const indexToShow = selectedIndexType === 'content-index' ? indexName : indexName.replace('search-', _constants.CONNECTORS_ACCESS_CONTROL_INDEX_PREFIX);
  const mappingLogic = (0, _mappings_logic.mappingsWithPropsApiLogic)(indexToShow);
  const documentLogic = (0, _search_documents_api_logic.searchDocumentsApiLogic)(indexToShow);
  const {
    makeRequest: getDocuments
  } = (0, _kea.useActions)(documentLogic);
  const {
    makeRequest: getMappings
  } = (0, _kea.useActions)(mappingLogic);
  const {
    data,
    status
  } = (0, _kea.useValues)(documentLogic);
  const {
    data: mappingData,
    status: mappingStatus
  } = (0, _kea.useValues)(mappingLogic);
  const docs = (_data$results$hits$hi = data === null || data === void 0 ? void 0 : (_data$results = data.results) === null || _data$results === void 0 ? void 0 : _data$results.hits.hits) !== null && _data$results$hits$hi !== void 0 ? _data$results$hits$hi : [];
  const [pagination, setPagination] = (0, _react.useState)(DEFAULT_PAGINATION);
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const shouldShowAccessControlSwitcher = hasDocumentLevelSecurityFeature && productFeatures.hasDocumentLevelSecurityEnabled;
  (0, _react.useEffect)(() => {
    getDocuments({
      indexName: indexToShow,
      pagination,
      query: searchQuery
    });
  }, [indexToShow, pagination, searchQuery]);
  (0, _react.useEffect)(() => {
    setSearchQuery('');
    setPagination(DEFAULT_PAGINATION);
    getMappings({
      indexName: indexToShow
    });
  }, [indexToShow]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "enterpriseSearchDocumentsHeader",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.title', {
    defaultMessage: 'Browse documents'
  })))), shouldShowAccessControlSwitcher && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_access_control_index_selector.AccessControlIndexSelector, {
    onChange: setSelectedIndexType,
    valueOfSelected: selectedIndexType
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-documents-searchDocuments`,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.searchField.placeholder', {
      defaultMessage: 'Search documents in this index'
    }),
    isClearable: true,
    onChange: event => setSearchQuery(event.target.value),
    fullWidth: true
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, docs.length === 0 && _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.noMappings', {
    defaultMessage: 'No documents found for index'
  }), docs.length > 0 && /*#__PURE__*/_react.default.createElement(_document_list.DocumentList, {
    docs: docs,
    docsPerPage: pagination.pageSize,
    isLoading: status !== _api.Status.SUCCESS && mappingStatus !== _api.Status.SUCCESS,
    mappings: (_mappingData$mappings = mappingData === null || mappingData === void 0 ? void 0 : (_mappingData$mappings2 = mappingData.mappings) === null || _mappingData$mappings2 === void 0 ? void 0 : _mappingData$mappings2.properties) !== null && _mappingData$mappings !== void 0 ? _mappingData$mappings : {},
    meta: (_data$meta = data === null || data === void 0 ? void 0 : data.meta) !== null && _data$meta !== void 0 ? _data$meta : _constants2.DEFAULT_META,
    onPaginate: pageIndex => setPagination({
      ...pagination,
      pageIndex
    }),
    setDocsPerPage: pageSize => setPagination({
      ...pagination,
      pageSize
    })
  }))));
};
exports.SearchIndexDocuments = SearchIndexDocuments;