"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexDomainManagement = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../shared/constants");
var _loading = require("../../../../../shared/loading");
var _delete_crawler_domain_api_logic = require("../../../../api/crawler/delete_crawler_domain_api_logic");
var _crawler_domain_detail = require("../crawler_domain_detail/crawler_domain_detail");
var _add_domain_flyout = require("./add_domain/add_domain_flyout");
var _crawler_status_banner = require("./crawler_status_banner");
var _delete_domain_modal = require("./delete_domain_modal");
var _domain_management_logic = require("./domain_management_logic");
var _domains_panel = require("./domains_panel");
var _empty_state_panel = require("./empty_state_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchIndexDomainManagement = () => {
  _delete_crawler_domain_api_logic.DeleteCrawlerDomainApiLogic.mount();
  const {
    getDomains
  } = (0, _kea.useActions)(_domain_management_logic.DomainManagementLogic);
  const {
    domains,
    indexName,
    isLoading
  } = (0, _kea.useValues)(_domain_management_logic.DomainManagementLogic);
  (0, _react.useEffect)(() => {
    getDomains(_constants.DEFAULT_META);
  }, [indexName]);
  const {
    detailId
  } = (0, _reactRouterDom.useParams)();
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_loading.Loading, null);
  }
  return detailId ? /*#__PURE__*/_react.default.createElement(_crawler_domain_detail.CrawlerDomainDetail, {
    domainId: detailId
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_crawler_status_banner.CrawlerStatusBanner, null), domains.length > 0 ? /*#__PURE__*/_react.default.createElement(_domains_panel.DomainsPanel, null) : /*#__PURE__*/_react.default.createElement(_empty_state_panel.EmptyStatePanel, null), /*#__PURE__*/_react.default.createElement(_delete_domain_modal.DeleteDomainModal, null), /*#__PURE__*/_react.default.createElement(_add_domain_flyout.AddDomainFlyout, null));
};
exports.SearchIndexDomainManagement = SearchIndexDomainManagement;