"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlerDomainTabId = exports.CrawlerDomainDetailTabs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _authentication_panel = require("./authentication_panel/authentication_panel");
var _crawl_rules_table = require("./crawl_rules_table");
var _deduplication_panel = require("./deduplication_panel/deduplication_panel");
var _entry_points_table = require("./entry_points_table");
var _extraction_rules = require("./extraction_rules/extraction_rules");
var _sitemaps_table = require("./sitemaps_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let CrawlerDomainTabId;
exports.CrawlerDomainTabId = CrawlerDomainTabId;
(function (CrawlerDomainTabId) {
  CrawlerDomainTabId["ENTRY_POINTS"] = "entry_points";
  CrawlerDomainTabId["AUTHENTICATION"] = "authentication";
  CrawlerDomainTabId["SITE_MAPS"] = "site_maps";
  CrawlerDomainTabId["CRAWL_RULES"] = "crawl_rules";
  CrawlerDomainTabId["EXTRACTION_RULES"] = "extraction_rules";
  CrawlerDomainTabId["DEDUPLICATION"] = "deduplication";
})(CrawlerDomainTabId || (exports.CrawlerDomainTabId = CrawlerDomainTabId = {}));
const CrawlerDomainDetailTabs = ({
  domain,
  indexName
}) => {
  const [tabIndex, setTabIndex] = (0, _react.useState)(0);
  const tabs = [{
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_entry_points_table.EntryPointsTable, {
      domain: domain,
      indexName: indexName,
      items: domain.entryPoints,
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.entryPointsTable.title', {
        defaultMessage: 'Entry points'
      })))
    })),
    id: CrawlerDomainTabId.ENTRY_POINTS,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.entryPoints', {
      defaultMessage: 'Entry points'
    })
  }, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_authentication_panel.AuthenticationPanel, null)),
    id: CrawlerDomainTabId.AUTHENTICATION,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.authentication', {
      defaultMessage: 'Authentication'
    })
  }, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_sitemaps_table.SitemapsTable, {
      domain: domain,
      indexName: indexName,
      items: domain.sitemaps,
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.sitemapsTable.title', {
        defaultMessage: 'Sitemaps'
      })))
    })),
    id: CrawlerDomainTabId.SITE_MAPS,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.siteMaps', {
      defaultMessage: 'Site maps'
    })
  }, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_crawl_rules_table.CrawlRulesTable, {
      domainId: domain.id,
      indexName: indexName,
      crawlRules: domain.crawlRules,
      defaultCrawlRule: domain.defaultCrawlRule,
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRulesTable.title', {
        defaultMessage: 'Crawl rules'
      })))
    })),
    id: CrawlerDomainTabId.CRAWL_RULES,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.crawlRules', {
      defaultMessage: 'Crawl rules'
    })
  }, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_extraction_rules.ExtractionRules, null)),
    id: CrawlerDomainTabId.EXTRACTION_RULES,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules', {
      defaultMessage: 'Extraction rules'
    })
  }, {
    content: /*#__PURE__*/_react.default.createElement(_deduplication_panel.DeduplicationPanel, null),
    id: CrawlerDomainTabId.DEDUPLICATION,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.deduplication', {
      defaultMessage: 'Duplicate document handling'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    selectedTab: tabs[tabIndex],
    onTabClick: tab => {
      setTabIndex(tabs.findIndex(({
        id
      }) => id === tab.id) || 0);
    }
  });
};
exports.CrawlerDomainDetailTabs = CrawlerDomainDetailTabs;