"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthenticationPanelEditContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../shared/constants");
var _authentication_panel_logic = require("./authentication_panel_logic");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AuthenticationPanelEditContent = () => {
  const {
    selectAuthOption,
    setHeaderContent,
    setPassword,
    setUsername
  } = (0, _kea.useActions)(_authentication_panel_logic.AuthenticationPanelLogic);
  const {
    headerContent,
    username,
    password,
    selectedAuthOption
  } = (0, _kea.useValues)(_authentication_panel_logic.AuthenticationPanelLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-authentication-basicAuthentication",
    id: "basicAuthenticationCheckableCard",
    className: "authenticationCheckable",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, _constants2.AUTHENTICATION_LABELS.basic)),
    value: "basic",
    checked: selectedAuthOption === 'basic',
    onChange: () => selectAuthOption('basic')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.USERNAME_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: username,
    onChange: event => setUsername(event.target.value),
    disabled: selectedAuthOption !== 'basic'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.PASSWORD_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    type: "dual",
    value: password,
    onChange: event => setPassword(event.target.value),
    disabled: selectedAuthOption !== 'basic'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-authentication-authenticationHeader",
    id: "authenticationHeaderCheckableCard",
    className: "authenticationCheckable",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, _constants2.AUTHENTICATION_LABELS.raw)),
    value: "raw",
    checked: selectedAuthOption === 'raw',
    onChange: () => selectAuthOption('raw')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.authenticationPanel.editForm.headerValueLabel', {
      defaultMessage: 'Header value'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    type: "dual",
    value: headerContent,
    onChange: event => setHeaderContent(event.target.value),
    disabled: selectedAuthOption !== 'raw'
  })))))));
};
exports.AuthenticationPanelEditContent = AuthenticationPanelEditContent;