"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NATIVE_CONNECTORS = exports.CUSTOM_CONNECTORS = exports.CONNECTORS_DICT = exports.CONNECTORS = exports.BETA_CONNECTORS = void 0;
var _connectors = require("../../../../../../common/connectors/connectors");
var _doc_links = require("../../../../shared/doc_links");
var _connector_icons = require("../../../../shared/icons/connector_icons");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CONNECTORS_DICT = {
  azure_blob_storage: {
    docsUrl: _doc_links.docLinks.connectorsAzureBlobStorage,
    externalAuthDocsUrl: 'https://learn.microsoft.com/azure/storage/common/authorize-data-access',
    externalDocsUrl: 'https://learn.microsoft.com/azure/storage/blobs/',
    icon: _connector_icons.CONNECTOR_ICONS.azure_blob_storage
  },
  confluence: {
    docsUrl: _doc_links.docLinks.connectorsConfluence,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    icon: _connector_icons.CONNECTOR_ICONS.confluence_cloud
  },
  custom: {
    docsUrl: _doc_links.docLinks.connectors,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    icon: _connector_icons.CONNECTOR_ICONS.custom
  },
  dropbox: {
    docsUrl: _doc_links.docLinks.connectorsDropbox,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    icon: _connector_icons.CONNECTOR_ICONS.dropbox
  },
  google_cloud_storage: {
    docsUrl: _doc_links.docLinks.connectorsGoogleCloudStorage,
    externalAuthDocsUrl: 'https://cloud.google.com/storage/docs/authentication',
    externalDocsUrl: 'https://cloud.google.com/storage/docs',
    icon: _connector_icons.CONNECTOR_ICONS.google_cloud_storage
  },
  jira: {
    docsUrl: _doc_links.docLinks.connectorsJira,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    icon: _connector_icons.CONNECTOR_ICONS.jira_cloud
  },
  mongodb: {
    docsUrl: _doc_links.docLinks.connectorsMongoDB,
    externalAuthDocsUrl: 'https://www.mongodb.com/docs/atlas/app-services/authentication/',
    externalDocsUrl: 'https://www.mongodb.com/docs/',
    icon: _connector_icons.CONNECTOR_ICONS.mongodb
  },
  mssql: {
    docsUrl: _doc_links.docLinks.connectorsMicrosoftSQL,
    externalAuthDocsUrl: 'https://learn.microsoft.com/sql/relational-databases/security/authentication-access/getting-started-with-database-engine-permissions',
    externalDocsUrl: 'https://learn.microsoft.com/sql/',
    icon: _connector_icons.CONNECTOR_ICONS.microsoft_sql
  },
  mysql: {
    docsUrl: _doc_links.docLinks.connectorsMySQL,
    externalDocsUrl: 'https://dev.mysql.com/doc/',
    icon: _connector_icons.CONNECTOR_ICONS.mysql
  },
  network_drive: {
    docsUrl: _doc_links.docLinks.connectorsNetworkDrive,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    icon: _connector_icons.CONNECTOR_ICONS.network_drive
  },
  oracle: {
    docsUrl: _doc_links.docLinks.connectorsOracle,
    externalAuthDocsUrl: 'https://docs.oracle.com/en/database/oracle/oracle-database/19/dbseg/index.html',
    externalDocsUrl: 'https://docs.oracle.com/database/oracle/oracle-database/',
    icon: _connector_icons.CONNECTOR_ICONS.oracle
  },
  postgresql: {
    docsUrl: _doc_links.docLinks.connectorsPostgreSQL,
    externalAuthDocsUrl: 'https://www.postgresql.org/docs/15/auth-methods.html',
    externalDocsUrl: 'https://www.postgresql.org/docs/',
    icon: _connector_icons.CONNECTOR_ICONS.postgresql
  },
  s3: {
    docsUrl: _doc_links.docLinks.connectorsS3,
    externalAuthDocsUrl: 'https://docs.aws.amazon.com/s3/index.html',
    externalDocsUrl: '',
    icon: _connector_icons.CONNECTOR_ICONS.amazon_s3
  },
  servicenow: {
    docsUrl: _doc_links.docLinks.connectorsServiceNow,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    icon: _connector_icons.CONNECTOR_ICONS.servicenow
  },
  sharepoint: {
    docsUrl: _doc_links.docLinks.connectorsSharepoint,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    icon: _connector_icons.CONNECTOR_ICONS.sharepoint,
    platinumOnly: true
  },
  sharepoint_online: {
    docsUrl: _doc_links.docLinks.connectorsSharepointOnline,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    icon: _connector_icons.CONNECTOR_ICONS.sharepoint_online,
    platinumOnly: true
  }
};
exports.CONNECTORS_DICT = CONNECTORS_DICT;
const CONNECTORS = _connectors.CONNECTOR_DEFINITIONS.map(connector => ({
  ...connector,
  ...(connector.serviceType && CONNECTORS_DICT[connector.serviceType] ? CONNECTORS_DICT[connector.serviceType] : CONNECTORS_DICT.custom)
}));
exports.CONNECTORS = CONNECTORS;
const CUSTOM_CONNECTORS = CONNECTORS.filter(({
  isNative
}) => !isNative);
exports.CUSTOM_CONNECTORS = CUSTOM_CONNECTORS;
const NATIVE_CONNECTORS = CONNECTORS.filter(({
  isNative
}) => isNative);
exports.NATIVE_CONNECTORS = NATIVE_CONNECTORS;
const BETA_CONNECTORS = CONNECTORS.filter(({
  isBeta
}) => isBeta);
exports.BETA_CONNECTORS = BETA_CONNECTORS;