"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorCronEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../../../common/types/api");
var _connectors = require("../../../../../../../common/types/connectors");
var _cron_editor = require("../../../../../shared/cron_editor");
var _update_connector_scheduling_api_logic = require("../../../../api/connector/update_connector_scheduling_api_logic");
var _connector_scheduling_logic = require("../connector_scheduling_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorCronEditor = ({
  disabled = false,
  frequencyBlockList = ['MINUTE'],
  scheduling,
  onSave,
  onReset,
  type
}) => {
  var _scheduling$interval;
  const {
    status
  } = (0, _kea.useValues)(_update_connector_scheduling_api_logic.UpdateConnectorSchedulingApiLogic);
  const {
    hasFullSyncChanges,
    hasAccessSyncChanges,
    hasIncrementalSyncChanges
  } = (0, _kea.useValues)(_connector_scheduling_logic.ConnectorSchedulingLogic);
  const {
    clearHasChanges,
    setHasChanges
  } = (0, _kea.useActions)(_connector_scheduling_logic.ConnectorSchedulingLogic);
  const [newInterval, setNewInterval] = (0, _react.useState)(scheduling.interval);
  const [fieldToPreferredValueMap, setFieldToPreferredValueMap] = (0, _react.useState)({});
  const [simpleCron, setSimpleCron] = (0, _react.useState)({
    expression: (_scheduling$interval = scheduling.interval) !== null && _scheduling$interval !== void 0 ? _scheduling$interval : '',
    frequency: scheduling.interval ? cronToFrequency(scheduling.interval) : 'HOUR'
  });
  const hasChanges = type === _connectors.SyncJobType.FULL ? hasFullSyncChanges : type === _connectors.SyncJobType.INCREMENTAL ? hasIncrementalSyncChanges : hasAccessSyncChanges;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_cron_editor.CronEditor, {
    "data-telemetry-id": "entSearchContent-connector-scheduling-editSchedule",
    disabled: !scheduling.enabled || disabled,
    fieldToPreferredValueMap: fieldToPreferredValueMap,
    cronExpression: simpleCron.expression,
    frequency: simpleCron.frequency,
    onChange: ({
      cronExpression: expression,
      frequency,
      fieldToPreferredValueMap: newFieldToPreferredValueMap
    }) => {
      setSimpleCron({
        expression,
        frequency
      });
      setFieldToPreferredValueMap(newFieldToPreferredValueMap);
      setNewInterval(expression);
      setHasChanges(type);
    },
    frequencyBlockList: frequencyBlockList
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchContent-connector-scheduling-resetSchedule",
    disabled: !hasChanges || status === _api.Status.LOADING || disabled,
    onClick: () => {
      var _scheduling$interval2;
      setNewInterval(scheduling.interval);
      setSimpleCron({
        expression: (_scheduling$interval2 = scheduling.interval) !== null && _scheduling$interval2 !== void 0 ? _scheduling$interval2 : '',
        frequency: scheduling.interval ? cronToFrequency(scheduling.interval) : 'HOUR'
      });
      clearHasChanges(type);
      if (onReset) {
        onReset();
      }
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.resetButton.label', {
    defaultMessage: 'Reset'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-connector-scheduling-saveSchedule",
    disabled: !hasChanges || status === _api.Status.LOADING || disabled,
    onClick: () => onSave && onSave(newInterval)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.saveButton.label', {
    defaultMessage: 'Save'
  }))))));
};
exports.ConnectorCronEditor = ConnectorCronEditor;
function cronToFrequency(cron) {
  const fields = cron.split(' ');
  if (fields.length < 4) {
    return 'YEAR';
  }
  if (fields[1] === '*' || fields[1].includes(',')) {
    return 'MINUTE';
  }
  if (fields[2] === '*') {
    return 'HOUR';
  }
  if (fields[3] === '*') {
    return 'DAY';
  }
  if (fields[3] === '?') {
    return 'WEEK';
  }
  if (fields[4] === '*') {
    return 'MONTH';
  }
  return 'YEAR';
}