"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfigurationField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../../common/types/api");
var _connectors = require("../../../../../../common/types/connectors");
var _licensing = require("../../../../shared/licensing");
var _update_connector_configuration_api_logic = require("../../../api/connector/update_connector_configuration_api_logic");
var _platinum_license_popover = require("../../shared/platinum_license_popover/platinum_license_popover");
var _connector_configuration_logic = require("./connector_configuration_logic");
var _document_level_security_panel = require("./document_level_security/document_level_security_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorConfigurationField = ({
  configEntry
}) => {
  const {
    status
  } = (0, _kea.useValues)(_update_connector_configuration_api_logic.ConnectorConfigurationApiLogic);
  const {
    setLocalConfigEntry
  } = (0, _kea.useActions)(_connector_configuration_logic.ConnectorConfigurationLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    key,
    display,
    is_valid: isValid,
    label,
    options,
    required,
    placeholder,
    sensitive,
    tooltip,
    value
  } = configEntry;
  switch (display) {
    case _connectors.DisplayType.DROPDOWN:
      return options.length > 3 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        disabled: status === _api.Status.LOADING,
        options: options.map(option => ({
          text: option.label,
          value: option.value
        })),
        required: required,
        value: (0, _connector_configuration_logic.ensureStringType)(value),
        onChange: event => {
          setLocalConfigEntry({
            ...configEntry,
            value: event.target.value
          });
        }
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
        disabled: status === _api.Status.LOADING,
        idSelected: (0, _connector_configuration_logic.ensureStringType)(value),
        name: "radio group",
        options: options.map(option => ({
          id: option.value,
          label: option.label
        })),
        onChange: id => {
          setLocalConfigEntry({
            ...configEntry,
            value: id
          });
        }
      });
    case _connectors.DisplayType.NUMERIC:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        disabled: status === _api.Status.LOADING,
        required: required,
        value: (0, _connector_configuration_logic.ensureStringType)(value),
        isInvalid: !isValid,
        onChange: event => {
          setLocalConfigEntry({
            ...configEntry,
            value: event.target.value
          });
        },
        placeholder: placeholder
      });
    case _connectors.DisplayType.TEXTAREA:
      const textarea = /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
        disabled: status === _api.Status.LOADING,
        placeholder: placeholder,
        required: required,
        value: (0, _connector_configuration_logic.ensureStringType)(value) || undefined // ensures placeholder shows up when value is empty string
        ,
        onChange: event => {
          setLocalConfigEntry({
            ...configEntry,
            value: event.target.value
          });
        }
      });
      return sensitive ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
        id: key + '-accordion',
        buttonContent: tooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "xs"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("p", null, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "questionInCircle"
        }))) : /*#__PURE__*/_react.default.createElement("p", null, label)
      }, textarea) : textarea;
    case _connectors.DisplayType.TOGGLE:
      if (key === 'use_document_level_security') {
        return /*#__PURE__*/_react.default.createElement(_document_level_security_panel.DocumentLevelSecurityPanel, {
          toggleSwitch: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            responsive: false,
            gutterSize: "s"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
            checked: (0, _connector_configuration_logic.ensureBooleanType)(value),
            disabled: status === _api.Status.LOADING || !hasPlatinumLicense,
            label: /*#__PURE__*/_react.default.createElement("p", null, label),
            onChange: event => {
              setLocalConfigEntry({
                ...configEntry,
                value: event.target.checked
              });
            }
          })), !hasPlatinumLicense && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_platinum_license_popover.PlatinumLicensePopover, {
            button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
              "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.selectConnector.openPopoverLabel', {
                defaultMessage: 'Open licensing popover'
              }),
              iconType: "questionInCircle",
              onClick: () => setIsPopoverOpen(!isPopoverOpen)
            }),
            closePopover: () => setIsPopoverOpen(false),
            isPopoverOpen: isPopoverOpen
          })))
        });
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        checked: (0, _connector_configuration_logic.ensureBooleanType)(value),
        disabled: status === _api.Status.LOADING,
        label: tooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "xs"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("p", null, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "questionInCircle"
        }))) : /*#__PURE__*/_react.default.createElement("p", null, label),
        onChange: event => {
          setLocalConfigEntry({
            ...configEntry,
            value: event.target.checked
          });
        }
      });
    default:
      return sensitive ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
        disabled: status === _api.Status.LOADING,
        required: required,
        type: "dual",
        value: (0, _connector_configuration_logic.ensureStringType)(value),
        onChange: event => {
          setLocalConfigEntry({
            ...configEntry,
            value: event.target.value
          });
        }
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        disabled: status === _api.Status.LOADING,
        placeholder: placeholder,
        required: required,
        value: (0, _connector_configuration_logic.ensureStringType)(value),
        onChange: event => {
          setLocalConfigEntry({
            ...configEntry,
            value: event.target.value
          });
        }
      });
  }
};
exports.ConnectorConfigurationField = ConnectorConfigurationField;