"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewSearchIndexPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _query_params = require("../../../shared/query_params");
var _page_template = require("../layout/page_template");
var _constants2 = require("../search_index/connector/constants");
var _search_indices = require("../search_indices");
var _method_api = require("./method_api/method_api");
var _method_connector = require("./method_connector/method_connector");
var _method_crawler = require("./method_crawler/method_crawler");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTitle(method, serviceType) {
  switch (method) {
    case _constants.INGESTION_METHOD_IDS.API:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.apiTitle', {
        defaultMessage: 'New search index'
      });
    case _constants.INGESTION_METHOD_IDS.CONNECTOR:
      {
        const connector = Boolean(serviceType) && _constants2.CONNECTORS.find(item => item.serviceType === serviceType);
        return connector ? _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.connectorTitleWithServiceType', {
          defaultMessage: 'New {name} search index',
          values: {
            name: connector.name
          }
        }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.connectorTitle', {
          defaultMessage: 'New connector search index'
        });
      }
    case _constants.INGESTION_METHOD_IDS.CRAWLER:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.crawlerTitle', {
        defaultMessage: 'Web crawler search index'
      });
    default:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.genericTitle', {
        defaultMessage: 'New search index'
      });
  }
}
function getDescription(method) {
  switch (method) {
    case _constants.INGESTION_METHOD_IDS.API:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.apiDescription', {
        defaultMessage: 'Use the API to programatically add documents to an Elasticsearch index. Start by creating your index.'
      });
    case _constants.INGESTION_METHOD_IDS.CONNECTOR:
      {
        return _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.connectorDescriptionWithServiceType', {
          defaultMessage: 'Use a connector to sync, extract, transform and index data from your data source. Connectors are Elastic integrations that write directly to Elasticsearch indices.'
        });
      }
    case _constants.INGESTION_METHOD_IDS.CRAWLER:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.crawlerDescription', {
        defaultMessage: 'Use the web crawler to programmatically discover, extract, and index searchable content from websites and knowledge bases.'
      });
    default:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.defaultDescription', {
        defaultMessage: 'A search index stores your data.'
      });
  }
}
const NewSearchIndexPage = () => {
  const type = decodeURIComponent((0, _reactRouterDom.useParams)().type);
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    service_type: inputServiceType
  } = (0, _query_params.parseQueryParams)(search);
  const serviceType = Array.isArray(inputServiceType) ? inputServiceType[0] : inputServiceType || '';
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchContentPageTemplate, {
    pageChrome: [..._search_indices.baseBreadcrumbs, 'New search index'],
    pageViewTelemetry: "New Index",
    isLoading: false,
    pageHeader: {
      description: getDescription(type),
      pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: (0, _utils.getIngestionMethodIconType)(type),
        size: "xxl"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, getTitle(type, serviceType)))
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, type === _constants.INGESTION_METHOD_IDS.CRAWLER && /*#__PURE__*/_react.default.createElement(_method_crawler.MethodCrawler, null), type === _constants.INGESTION_METHOD_IDS.API && /*#__PURE__*/_react.default.createElement(_method_api.MethodApi, null), type === _constants.INGESTION_METHOD_IDS.CONNECTOR && /*#__PURE__*/_react.default.createElement(_method_connector.MethodConnector, {
    serviceType: serviceType
  })));
};
exports.NewSearchIndexPage = NewSearchIndexPage;