"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateExtractionRule = exports.UpdateExtractionRuleApiLogic = void 0;
var _create_api_logic = require("../../../../shared/api_logic/create_api_logic");
var _http = require("../../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateExtractionRule = async ({
  domainId,
  indexName,
  rule
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}/crawler/domains/${domainId}/extraction_rules/${rule.id}`;
  const params = {
    extraction_rule: {
      description: rule.description,
      rules: rule.rules,
      url_filters: rule.url_filters
    }
  };
  return await _http.HttpLogic.values.http.put(route, {
    body: JSON.stringify(params)
  });
};
exports.updateExtractionRule = updateExtractionRule;
const UpdateExtractionRuleApiLogic = (0, _create_api_logic.createApiLogic)(['update_extraction_rule_api_logic'], updateExtractionRule);
exports.UpdateExtractionRuleApiLogic = UpdateExtractionRuleApiLogic;