"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteExtractionRule = exports.DeleteExtractionRuleApiLogic = void 0;
var _create_api_logic = require("../../../../shared/api_logic/create_api_logic");
var _http = require("../../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteExtractionRule = async ({
  domainId,
  extractionRuleId,
  indexName
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}/crawler/domains/${domainId}/extraction_rules/${extractionRuleId}`;
  return await _http.HttpLogic.values.http.delete(route);
};
exports.deleteExtractionRule = deleteExtractionRule;
const DeleteExtractionRuleApiLogic = (0, _create_api_logic.createApiLogic)(['delete_extraction_rule_api_logic'], deleteExtractionRule);
exports.DeleteExtractionRuleApiLogic = DeleteExtractionRuleApiLogic;