"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchGuide = void 0;
var _react = _interopRequireWildcard(require("react"));
var _queryString = _interopRequireDefault(require("query-string"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../../../shared/doc_links");
var _elasticsearch_resources = require("../../../shared/elasticsearch_resources");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _elasticsearch_client_instructions = require("../elasticsearch_client_instructions");
var _elasticsearch_cloud_id = require("../elasticsearch_cloud_id");
var _layout = require("../layout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Replace FormattedMessage with i18n strings

const ElasticsearchGuide = () => {
  const languages = [{
    value: 'dotnet',
    text: '.Net'
  }, {
    value: 'go',
    text: 'Go'
  }, {
    value: 'java',
    text: 'Java'
  }, {
    value: 'javascript',
    text: 'JavaScript'
  }, {
    value: 'php',
    text: 'PHP'
  }, {
    value: 'python',
    text: 'Python'
  }, {
    value: 'ruby',
    text: 'Ruby'
  }, {
    value: 'rust',
    text: 'Rust'
  }];
  const client = _queryString.default.parse(window.location.search).client;
  const languageExists = languages.some(language => language.value === client);
  const [selectedLanguage, setSelectedLanguage] = (0, _react.useState)(languageExists ? client : 'java');
  const basicSelectId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'languageSelect'
  });
  const onChange = e => {
    setSelectedLanguage(e.target.value);
  };

  // TODO: The page keeps the scroll position if being opened from Enterpise Search Overview,
  // This is a temporary solution for demoing
  (0, _react.useEffect)(() => {
    window.scrollTo(0, 0);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchElasticsearchPageTemplate, null, /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetElasticsearchChrome, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    "data-test-subj": "elasticsearchGuide"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    style: {
      maxWidth: 800
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchGuide.elasticsearchTitle', {
    defaultMessage: 'Getting started with Elasticsearch'
  })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchGuide.elasticsearchDescription', {
    defaultMessage: "Elasticsearch provides the low-level tools you need to build fast, relevant search for your website or application. Because it's powerful and flexible, Elasticsearch can handle search use cases of all shapes and sizes."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    headingElement: "h2",
    steps: [{
      title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchGuide.connectToElasticsearchTitle', {
        defaultMessage: 'Connect to Elasticsearch'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchGuide.connectToElasticsearchDescription', {
        defaultMessage: 'Elastic builds and maintains clients in several popular languages and our community has contributed many more.'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.clientsGuide,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchGuide.elasticsearchClientsLink', {
        defaultMessage: 'Learn more about Elasticsearch clients'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        prepend: _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchGuide.elasticsearchClientsSelectLabel', {
          defaultMessage: 'Select a client'
        }),
        id: basicSelectId,
        options: languages,
        value: selectedLanguage,
        onChange: e => onChange(e),
        "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchGuide.elasticsearchClientsSelectAriaLabel', {
          defaultMessage: 'Language client'
        })
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_elasticsearch_client_instructions.ElasticsearchClientInstructions, {
        language: selectedLanguage
      }))
    }, {
      title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchGuide.elasticsearchSearchExperienceTitle', {
        defaultMessage: 'Build a search experience with Elasticsearch'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchGuide.elasticsearchSearchExperienceDescription', {
        defaultMessage: 'Ready to add an engaging, modern search experience to your application or website? Search UI, Elastic’s JavaScript search framework for building world-class search experiences, was made for the task.'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "l",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/enterprise-search/search-ui",
        target: "_blank"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchGuide.elasticsearchSearchUIMarketingLink', {
        defaultMessage: 'Learn more about Search UI'
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://github.com/elastic/search-ui",
        target: "_blank"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchGuide.elasticsearchSearchUIGitHubLink', {
        defaultMessage: 'Search UI on GitHub'
      }))))))
    }]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_elasticsearch_cloud_id.ElasticsearchCloudId, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_elasticsearch_resources.ElasticsearchResources, null))));
};
exports.ElasticsearchGuide = ElasticsearchGuide;