"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchGo = void 0;
var _react = _interopRequireDefault(require("react"));
var _dedent = _interopRequireDefault(require("dedent"));
var _eui = require("@elastic/eui");
var _doc_links = require("../../../../shared/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticsearchGo = ({
  cloudId
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "The official Go client for Elasticsearch includes all the features you need to add search to a Go application:"), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, "One-to-one mapping with the Elasticsearch REST API"), /*#__PURE__*/_react.default.createElement("li", null, "Generalized, pluggable architecture"), /*#__PURE__*/_react.default.createElement("li", null, "Helpers for convenience"), /*#__PURE__*/_react.default.createElement("li", null, "A rich set of examples in the documentation")), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: _doc_links.docLinks.clientsGoIndex
  }, "Learn more about the Go client for Elasticsearch"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: "https://github.com/elastic/go-elasticsearch"
  }, "The Go client for Elasticsearch on Github"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: "https://godoc.org/github.com/elastic/go-elasticsearch"
  }, "View the documentation on GoDoc")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Installation"), /*#__PURE__*/_react.default.createElement("p", null, "Add the package to your go.mod file:")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "go-module"
  }, (0, _dedent.default)`
          require github.com/elastic/go-elasticsearch/v8 main
        `), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Getting started"), /*#__PURE__*/_react.default.createElement("p", null, "The ", /*#__PURE__*/_react.default.createElement("code", null, "elasticsearch"), " package ties together two separate packages for calling the Elasticsearch APIs and transferring data over HTTP: ", /*#__PURE__*/_react.default.createElement("code", null, "esapi"), " and", ' ', /*#__PURE__*/_react.default.createElement("code", null, "elastictransport"), "."), /*#__PURE__*/_react.default.createElement("p", null, "Use the ", /*#__PURE__*/_react.default.createElement("code", null, "elasticsearch.NewDefaultClient()"), " function to create the client with the default settings.")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "go"
  }, (0, _dedent.default)`
          es, err := elasticsearch.NewDefaultClient()
          if err != nil {
            log.Fatalf("Error creating the client: %s", err)
          }
          
          res, err := es.Info()
          if err != nil {
            log.Fatalf("Error getting response: %s", err)
          }
          
          defer res.Body.Close()
          log.Println(res)
        `), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), cloudId ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Connecting to Elastic Cloud"), /*#__PURE__*/_react.default.createElement("p", null, "If you are using Elastic Cloud, the client offers an easy way to connect to it. You must pass your Cloud ID to the client, which is found in the Cloud console, as well as a corresponding API key.")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "go"
  }, (0, _dedent.default)`
              cfg := elasticsearch.Config{
                CloudID: "${cloudId}",
                APIKey: "API_KEY"
              }
              es, err := elasticsearch.NewClient(cfg)
            `)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Connecting to Elasticsearch"), /*#__PURE__*/_react.default.createElement("p", null, "To set the cluster endpoint(s) programmatically, pass a configuration object to the", ' ', /*#__PURE__*/_react.default.createElement("code", null, "elasticsearch.NewClient()"), " function. To set the username and password, include them in the endpoint URL, or use the corresponding configuration options.")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "go"
  }, (0, _dedent.default)`
              cfg := elasticsearch.Config{
                Addresses: []string{
                  "http://localhost:9200",
                  "http://localhost:9201",
                },
                Username: "<username>",
                Password: "<password>",
              }
              es, err := elasticsearch.NewClient(cfg)
            `)));
};
exports.ElasticsearchGo = ElasticsearchGo;