"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationViewTabs = exports.SearchApplicationContentTabs = exports.SearchApplicationConnectTabs = exports.SEARCH_APPLICATION_TAB_PATH = exports.SEARCH_APPLICATION_PATH = exports.SEARCH_APPLICATION_CREATION_PATH = exports.SEARCH_APPLICATION_CONTENT_PATH = exports.SEARCH_APPLICATION_CONNECT_PATH = exports.SEARCH_APPLICATIONS_PATH = exports.ROOT_PATH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ROOT_PATH = '/';
exports.ROOT_PATH = ROOT_PATH;
const SEARCH_APPLICATIONS_PATH = `${ROOT_PATH}search_applications`;
exports.SEARCH_APPLICATIONS_PATH = SEARCH_APPLICATIONS_PATH;
let SearchApplicationViewTabs;
exports.SearchApplicationViewTabs = SearchApplicationViewTabs;
(function (SearchApplicationViewTabs) {
  SearchApplicationViewTabs["PREVIEW"] = "preview";
  SearchApplicationViewTabs["CONTENT"] = "content";
  SearchApplicationViewTabs["CONNECT"] = "connect";
})(SearchApplicationViewTabs || (exports.SearchApplicationViewTabs = SearchApplicationViewTabs = {}));
const SEARCH_APPLICATION_CREATION_PATH = `${SEARCH_APPLICATIONS_PATH}/new`;
exports.SEARCH_APPLICATION_CREATION_PATH = SEARCH_APPLICATION_CREATION_PATH;
const SEARCH_APPLICATION_PATH = `${SEARCH_APPLICATIONS_PATH}/:searchApplicationName`;
exports.SEARCH_APPLICATION_PATH = SEARCH_APPLICATION_PATH;
const SEARCH_APPLICATION_TAB_PATH = `${SEARCH_APPLICATION_PATH}/:tabId`;
exports.SEARCH_APPLICATION_TAB_PATH = SEARCH_APPLICATION_TAB_PATH;
const SEARCH_APPLICATION_CONNECT_PATH = `${SEARCH_APPLICATION_PATH}/${SearchApplicationViewTabs.CONNECT}/:connectTabId`;
exports.SEARCH_APPLICATION_CONNECT_PATH = SEARCH_APPLICATION_CONNECT_PATH;
let SearchApplicationConnectTabs;
exports.SearchApplicationConnectTabs = SearchApplicationConnectTabs;
(function (SearchApplicationConnectTabs) {
  SearchApplicationConnectTabs["SEARCHAPI"] = "search_api";
  SearchApplicationConnectTabs["DOCUMENTATION"] = "documentation";
})(SearchApplicationConnectTabs || (exports.SearchApplicationConnectTabs = SearchApplicationConnectTabs = {}));
const SEARCH_APPLICATION_CONTENT_PATH = `${SEARCH_APPLICATION_PATH}/${SearchApplicationViewTabs.CONTENT}/:contentTabId`;
exports.SEARCH_APPLICATION_CONTENT_PATH = SEARCH_APPLICATION_CONTENT_PATH;
let SearchApplicationContentTabs;
exports.SearchApplicationContentTabs = SearchApplicationContentTabs;
(function (SearchApplicationContentTabs) {
  SearchApplicationContentTabs["INDICES"] = "indices";
  SearchApplicationContentTabs["SCHEMA"] = "schema";
})(SearchApplicationContentTabs || (exports.SearchApplicationContentTabs = SearchApplicationContentTabs = {}));