"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationSearchPreviewLogic = void 0;
var _kea = require("kea");
var _fetch_search_application_field_capabilities_api_logic = require("../../../api/search_applications/fetch_search_application_field_capabilities_api_logic");
var _search_application_name_logic = require("../search_application_name_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchApplicationSearchPreviewLogic = (0, _kea.kea)({
  connect: {
    actions: [_fetch_search_application_field_capabilities_api_logic.FetchSearchApplicationFieldCapabilitiesApiLogic, ['makeRequest as fetchSearchApplicationFieldCapabilities']],
    values: [_search_application_name_logic.SearchApplicationNameLogic, ['searchApplicationName'], _fetch_search_application_field_capabilities_api_logic.FetchSearchApplicationFieldCapabilitiesApiLogic, ['data as searchApplicationFieldCapabilitiesData']]
  },
  events: ({
    actions,
    values
  }) => ({
    afterMount: () => {
      if (!values.searchApplicationFieldCapabilitiesData) {
        actions.fetchSearchApplicationFieldCapabilities({
          name: values.searchApplicationName
        });
      }
    }
  }),
  path: ['enterprise_search', 'content', 'search_application_search_preview_logic'],
  selectors: ({
    selectors
  }) => ({
    fieldTypesByIndex: [() => [selectors.searchApplicationFieldCapabilitiesData], data => {
      if (!data) return {};
      return data.fields.reduce((out, field) => field.indices.reduce((acc, index) => ({
        ...acc,
        [index.name]: {
          ...(acc[index.name] || {}),
          [field.name]: index.type
        }
      }), out), {});
    }],
    resultFields: [() => [selectors.searchApplicationFieldCapabilitiesData], data => {
      if (!data) return {};
      return Object.fromEntries(data.fields.filter(({
        metadata_field: isMeta
      }) => !isMeta).map(({
        name
      }) => [name, {
        raw: {},
        snippet: {
          fallback: true
        }
      }]));
    }],
    sortableFields: [() => [selectors.searchApplicationFieldCapabilitiesData], data => {
      if (!data) return [];
      return data.fields.filter(({
        metadata_field: isMeta,
        aggregatable
      }) => aggregatable && !isMeta).map(({
        name
      }) => name).sort();
    }]
  })
});
exports.SearchApplicationSearchPreviewLogic = SearchApplicationSearchPreviewLogic;