"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationViewLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../common/types/api");
var _kibana = require("../../../shared/kibana");
var _fetch_search_application_api_logic = require("../../api/search_applications/fetch_search_application_api_logic");
var _fetch_search_application_field_capabilities_api_logic = require("../../api/search_applications/fetch_search_application_field_capabilities_api_logic");
var _routes = require("../../routes");
var _search_applications_list_logic = require("../search_applications/search_applications_list_logic");
var _search_application_name_logic = require("./search_application_name_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchApplicationViewLogic = (0, _kea.kea)({
  actions: {
    closeDeleteSearchApplicationModal: true,
    openDeleteSearchApplicationModal: true
  },
  connect: {
    actions: [_fetch_search_application_api_logic.FetchSearchApplicationApiLogic, ['makeRequest as fetchSearchApplication'], _fetch_search_application_field_capabilities_api_logic.FetchSearchApplicationFieldCapabilitiesApiLogic, ['makeRequest as fetchSearchApplicationSchema'], _search_applications_list_logic.SearchApplicationsListLogic, ['deleteSuccess']],
    values: [_search_application_name_logic.SearchApplicationNameLogic, ['searchApplicationName'], _fetch_search_application_api_logic.FetchSearchApplicationApiLogic, ['data as searchApplicationData', 'status as fetchSearchApplicationApiStatus', 'error as fetchSearchApplicationApiError'], _fetch_search_application_field_capabilities_api_logic.FetchSearchApplicationFieldCapabilitiesApiLogic, ['data as searchApplicationSchemaData', 'status as fetchSearchApplicationSchemaApiStatus', 'error as fetchSearchApplicationSchemaApiError']]
  },
  listeners: ({
    actions
  }) => ({
    deleteSuccess: () => {
      actions.closeDeleteSearchApplicationModal();
      _kibana.KibanaLogic.values.navigateToUrl(_routes.SEARCH_APPLICATIONS_PATH);
    },
    fetchSearchApplication: ({
      name
    }) => {
      actions.fetchSearchApplicationSchema({
        name
      });
    }
  }),
  path: ['enterprise_search', 'content', 'search_application_view_logic'],
  reducers: () => ({
    isDeleteModalVisible: [false, {
      closeDeleteSearchApplicationModal: () => false,
      openDeleteSearchApplicationModal: () => true
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    hasSchemaConflicts: [() => [selectors.schemaFields], data => data.some(f => f.type === 'conflict')],
    isLoadingSearchApplication: [() => [selectors.fetchSearchApplicationApiStatus, selectors.searchApplicationData], (status, data) => {
      return status === _api.Status.IDLE || !data && status === _api.Status.LOADING;
    }],
    isLoadingSearchApplicationSchema: [() => [selectors.fetchSearchApplicationSchemaApiStatus], status => [_api.Status.LOADING, _api.Status.IDLE].includes(status)],
    schemaFields: [() => [selectors.searchApplicationSchemaData], data => (data === null || data === void 0 ? void 0 : data.fields) || []]
  })
});
exports.SearchApplicationViewLogic = SearchApplicationViewLogic;