"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _api = require("../../../../../common/types/api");
var _kibana = require("../../../shared/kibana");
var _routes = require("../../routes");
var _page_template = require("../layout/page_template");
var _delete_search_application_modal = require("../search_applications/delete_search_application_modal");
var _search_application_connect = require("./connect/search_application_connect");
var _header_docs_action = require("./header_docs_action");
var _search_application_content = require("./search_application_content");
var _search_application_error = require("./search_application_error");
var _search_application_view_logic = require("./search_application_view_logic");
var _search_preview = require("./search_preview/search_preview");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchApplicationView = () => {
  const {
    fetchSearchApplication,
    closeDeleteSearchApplicationModal
  } = (0, _kea.useActions)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    searchApplicationName,
    fetchSearchApplicationApiError,
    fetchSearchApplicationApiStatus,
    hasSchemaConflicts,
    isDeleteModalVisible
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    tabId = _routes.SearchApplicationViewTabs.PREVIEW
  } = (0, _reactRouterDom.useParams)();
  const {
    renderHeaderActions
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  (0, _react.useLayoutEffect)(() => {
    renderHeaderActions(_header_docs_action.SearchApplicationHeaderDocsAction);
    return () => {
      renderHeaderActions();
    };
  }, []);
  (0, _react.useEffect)(() => {
    fetchSearchApplication({
      name: searchApplicationName
    });
  }, [searchApplicationName]);
  if (fetchSearchApplicationApiStatus === _api.Status.ERROR) {
    return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchApplicationsPageTemplate, {
      isEmptyState: true,
      pageChrome: [searchApplicationName],
      pageViewTelemetry: tabId,
      pageHeader: {
        bottomBorder: false,
        pageTitle: searchApplicationName,
        rightSideItems: []
      },
      searchApplicationName: searchApplicationName,
      emptyState: /*#__PURE__*/_react.default.createElement(_search_application_error.SearchApplicationError, {
        error: fetchSearchApplicationApiError
      }),
      hasSchemaConflicts: hasSchemaConflicts
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDeleteModalVisible ? /*#__PURE__*/_react.default.createElement(_delete_search_application_modal.DeleteSearchApplicationModal, {
    searchApplicationName: searchApplicationName,
    onClose: closeDeleteSearchApplicationModal
  }) : null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${_routes.SEARCH_APPLICATION_PATH}/${_routes.SearchApplicationViewTabs.PREVIEW}`,
    component: _search_preview.SearchApplicationSearchPreview
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_APPLICATION_CONTENT_PATH,
    component: _search_application_content.SearchApplicationContent
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: `${_routes.SEARCH_APPLICATION_PATH}/${_routes.SearchApplicationViewTabs.CONTENT}`,
    to: `${_routes.SEARCH_APPLICATION_PATH}/${_routes.SearchApplicationViewTabs.CONTENT}/${_routes.SearchApplicationContentTabs.INDICES}`
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_APPLICATION_CONNECT_PATH,
    component: _search_application_connect.SearchApplicationConnect
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: `${_routes.SEARCH_APPLICATION_PATH}/${_routes.SearchApplicationViewTabs.CONNECT}`,
    to: `${_routes.SEARCH_APPLICATION_PATH}/${_routes.SearchApplicationViewTabs.CONNECT}/${_routes.SearchApplicationConnectTabs.SEARCHAPI}`
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchApplicationsPageTemplate, {
    isEmptyState: true,
    pageChrome: [searchApplicationName],
    pageViewTelemetry: tabId,
    pageHeader: {
      bottomBorder: false,
      pageTitle: searchApplicationName,
      rightSideItems: []
    },
    searchApplicationName: searchApplicationName,
    hasSchemaConflicts: hasSchemaConflicts
  }, /*#__PURE__*/_react.default.createElement(_search_application_error.SearchApplicationError, {
    notFound: true
  })))));
};
exports.SearchApplicationView = SearchApplicationView;