"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _encode_path_params = require("../../../shared/encode_path_params");
var _routes = require("../../routes");
var _search_application_name_logic = require("./search_application_name_logic");
var _search_application_view = require("./search_application_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchApplicationRouter = () => {
  const searchApplicationName = decodeURIComponent((0, _reactRouterDom.useParams)().searchApplicationName);
  const searchApplicationNameLogic = (0, _search_application_name_logic.SearchApplicationNameLogic)({
    searchApplicationName
  });
  const {
    setSearchApplicationName
  } = (0, _kea.useActions)(searchApplicationNameLogic);
  (0, _react.useEffect)(() => {
    const unmountName = searchApplicationNameLogic.mount();
    return () => {
      unmountName();
    };
  }, []);
  (0, _react.useEffect)(() => {
    setSearchApplicationName(searchApplicationName);
  }, [searchApplicationName]);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: _routes.SEARCH_APPLICATION_PATH,
    to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_TAB_PATH, {
      searchApplicationName,
      tabId: _routes.SearchApplicationViewTabs.PREVIEW
    }),
    exact: true
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_APPLICATION_TAB_PATH
  }, /*#__PURE__*/_react.default.createElement(_search_application_view.SearchApplicationView, null)));
};
exports.SearchApplicationRouter = SearchApplicationRouter;