"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SynonymCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _ = require("..");
var _constants = require("../../../../shared/constants");
var _2 = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SynonymCard = synonymSet => {
  const {
    openModal
  } = (0, _kea.useActions)(_.SynonymsLogic);
  const [firstSynonym, ...remainingSynonyms] = synonymSet.synonyms;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    display: "subdued",
    title: firstSynonym,
    titleElement: "h2",
    titleSize: "s",
    textAlign: "left",
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => openModal(synonymSet)
    }, _constants.MANAGE_BUTTON_LABEL)))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, remainingSynonyms.map(synonym => /*#__PURE__*/_react.default.createElement("div", {
    key: synonym
  }, /*#__PURE__*/_react.default.createElement(_2.SynonymIcon, null), " ", synonym))));
};
exports.SynonymCard = SynonymCard;