"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchUI = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _routes = require("../../routes");
var _engine = require("../engine");
var _layout = require("../layout");
var _empty_state = require("./components/empty_state");
var _search_ui_form = require("./components/search_ui_form");
var _search_ui_graphic = require("./components/search_ui_graphic");
var _i18n = require("./i18n");
var _search_ui_logic = require("./search_ui_logic");
require("./search_ui.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchUI = () => {
  const {
    loadFieldData
  } = (0, _kea.useActions)(_search_ui_logic.SearchUILogic);
  const {
    hasEmptySchema
  } = (0, _kea.useValues)(_engine.EngineLogic);
  (0, _react.useEffect)(() => {
    loadFieldData();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_i18n.SEARCH_UI_TITLE]),
    pageHeader: {
      pageTitle: _i18n.SEARCH_UI_TITLE
    },
    isEmptyState: hasEmptySchema,
    emptyState: /*#__PURE__*/_react.default.createElement(_empty_state.EmptyState, null)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.appSearch.engine.searchUI.bodyDescription",
    defaultMessage: "Search UI is a free and open library for building search experiences with React. {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: "https://github.com/elastic/search-ui"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.appSearch.engine.searchUI.repositoryLinkText",
        defaultMessage: "View the Github repo"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.appSearch.engine.searchUI.lowerBodyDescription",
    defaultMessage: "Use the fields below to generate a sample search experience built with Search UI. Use the sample to preview search results, or build upon it to create your own custom search experience. {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: _routes.SEARCH_UI_DOCS_URL
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.appSearch.engine.searchUI.guideLinkText",
        defaultMessage: "Learn more about Search UI"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_search_ui_form.SearchUIForm, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "searchUIGraphicContainer"
  }, /*#__PURE__*/_react.default.createElement(_search_ui_graphic.SearchUIGraphic, null))));
};
exports.SearchUI = SearchUI;