"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SampleResponse = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _query_performance = require("../query_performance");
var _result_settings_logic = require("../result_settings_logic");
var _sample_response_logic = require("./sample_response_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SampleResponse = () => {
  const {
    reducedServerResultFields
  } = (0, _kea.useValues)(_result_settings_logic.ResultSettingsLogic);
  const {
    query,
    response
  } = (0, _kea.useValues)(_sample_response_logic.SampleResponseLogic);
  const {
    queryChanged,
    getSearchResults
  } = (0, _kea.useActions)(_sample_response_logic.SampleResponseLogic);
  (0, _react.useEffect)(() => {
    getSearchResults(query, reducedServerResultFields);
  }, [query, reducedServerResultFields]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.sampleResponseTitle', {
    defaultMessage: 'Sample response'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_query_performance.QueryPerformance, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    value: query,
    onChange: e => queryChanged(e.target.value),
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.sampleResponse.inputPlaceholder', {
      defaultMessage: 'Type a search query to test a response...'
    }),
    "data-test-subj": "ResultSettingsQuerySampleResponse"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !!response && /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    whiteSpace: "pre-wrap"
  }, typeof response === 'string' ? response : JSON.stringify(response, null, 2)));
};
exports.SampleResponse = SampleResponse;