"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultSettingsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _ = require("..");
var _column_headers = require("./column_headers");
var _disabled_fields_body = require("./disabled_fields_body");
var _disabled_fields_header = require("./disabled_fields_header");
var _non_text_fields_body = require("./non_text_fields_body");
var _non_text_fields_header = require("./non_text_fields_header");
var _text_fields_body = require("./text_fields_body");
var _text_fields_header = require("./text_fields_header");
require("./result_settings_table.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResultSettingsTable = () => {
  const {
    schemaConflicts,
    textResultFields,
    nonTextResultFields
  } = (0, _kea.useValues)(_.ResultSettingsLogic);

  // TODO This table currently has mutiple theads, which is invalid html. We could change these subheaders to be EuiTableRow instead of EuiTableHeader
  // to alleviate the issue.
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    className: "resultSettingsTable",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_column_headers.ColumnHeaders, null), !!Object.keys(textResultFields).length && /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, /*#__PURE__*/_react.default.createElement(_text_fields_header.TextFieldsHeader, null), /*#__PURE__*/_react.default.createElement(_text_fields_body.TextFieldsBody, null)), !!Object.keys(nonTextResultFields).length && /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, {
    className: "resultSettingsTable__subHeader"
  }, /*#__PURE__*/_react.default.createElement(_non_text_fields_header.NonTextFieldsHeader, null), /*#__PURE__*/_react.default.createElement(_non_text_fields_body.NonTextFieldsBody, null)), !!Object.keys(schemaConflicts).length && /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, {
    className: "resultSettingsTable__subHeader"
  }, /*#__PURE__*/_react.default.createElement(_disabled_fields_header.DisabledFieldsHeader, null), /*#__PURE__*/_react.default.createElement(_disabled_fields_body.DisabledFieldsBody, null)));
};
exports.ResultSettingsTable = ResultSettingsTable;