"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CredentialsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../shared/constants");
var _hidden_text = require("../../../../shared/hidden_text");
var _table_pagination = require("../../../../shared/table_pagination");
var _routes = require("../../../routes");
var _constants2 = require("../constants");
var _credentials_logic = require("../credentials_logic");
var _utils = require("../utils");
var _api_token_sort = require("../utils/api_token_sort");
var _key = require("./key");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CredentialsList = () => {
  const {
    deleteApiKey,
    onPaginate,
    showCredentialsForm
  } = (0, _kea.useActions)(_credentials_logic.CredentialsLogic);
  const {
    apiTokens,
    meta,
    isCredentialsDataComplete
  } = (0, _kea.useValues)(_credentials_logic.CredentialsLogic);
  const items = (0, _react.useMemo)(() => apiTokens.slice().sort(_api_token_sort.apiTokenSort), [apiTokens]);
  const columns = [{
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.list.nameTitle', {
      defaultMessage: 'Name'
    }),
    width: '12%',
    render: token => token.name
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.list.typeTitle', {
      defaultMessage: 'Type'
    }),
    width: '15%',
    render: token => _constants2.TOKEN_TYPE_DISPLAY_NAMES[token.type]
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.list.keyTitle', {
      defaultMessage: 'Key'
    }),
    width: '36%',
    className: 'eui-textBreakAll',
    render: token => {
      const {
        key
      } = token;
      if (!key) return null;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
        textToCopy: key,
        afterMessage: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.copied', {
          defaultMessage: 'Copied'
        })
      }, copy => /*#__PURE__*/_react.default.createElement(_hidden_text.HiddenText, {
        text: key
      }, ({
        hiddenText,
        isHidden,
        toggle
      }) => /*#__PURE__*/_react.default.createElement(_key.Key, {
        copy: copy,
        toggleIsHidden: toggle,
        isHidden: isHidden,
        text: hiddenText
      })));
    },
    mobileOptions: {
      // @ts-ignore - EUI's type definitions need to be updated
      width: '100%'
    }
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.list.modesTitle', {
      defaultMessage: 'Modes'
    }),
    width: '10%',
    render: token => (0, _utils.getModeDisplayText)(token)
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.list.enginesTitle', {
      defaultMessage: 'Engines'
    }),
    width: '18%',
    render: token => (0, _utils.getEnginesDisplayText)(token)
  }, {
    actions: [{
      name: _constants.EDIT_BUTTON_LABEL,
      description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.editKey', {
        defaultMessage: 'Edit API Key'
      }),
      type: 'icon',
      icon: 'pencil',
      color: 'primary',
      onClick: token => showCredentialsForm(token)
    }, {
      name: _constants.DELETE_BUTTON_LABEL,
      description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.deleteKey', {
        defaultMessage: 'Delete API Key'
      }),
      type: 'icon',
      icon: 'trash',
      color: 'danger',
      onClick: token => deleteApiKey(token.name)
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: items,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "editorStrike",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.empty.title', {
        defaultMessage: 'Create your first API key'
      })),
      body: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.empty.body', {
        defaultMessage: 'Allow applications to access Elastic App Search on your behalf.'
      }),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        size: "s",
        target: "_blank",
        iconType: "popout",
        href: _routes.API_KEYS_DOCS_URL
      }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.empty.buttonLabel', {
        defaultMessage: 'Learn about API keys'
      }))
    }),
    loading: !isCredentialsDataComplete,
    pagination: {
      ...(0, _table_pagination.convertMetaToPagination)(meta),
      showPerPageOptions: false
    },
    onChange: (0, _table_pagination.handlePageChange)(onPaginate)
  });
};
exports.CredentialsList = CredentialsList;