"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartCrawlContextMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _crawler_logic = require("../../crawler_logic");
var _crawl_custom_settings_flyout_logic = require("../crawl_custom_settings_flyout/crawl_custom_settings_flyout_logic");
var _crawl_select_domains_modal_logic = require("../crawl_select_domains_modal/crawl_select_domains_modal_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StartCrawlContextMenu = ({
  menuButtonLabel,
  fill
}) => {
  const {
    startCrawl
  } = (0, _kea.useActions)(_crawler_logic.CrawlerLogic);
  const {
    showModal: showCrawlSelectDomainsModal
  } = (0, _kea.useActions)(_crawl_select_domains_modal_logic.CrawlSelectDomainsModalLogic);
  const {
    showFlyout: showCrawlCustomSettingsFlyout
  } = (0, _kea.useActions)(_crawl_custom_settings_flyout_logic.CrawlCustomSettingsFlyoutLogic);
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const togglePopover = () => setPopover(!isPopoverOpen);
  const closePopover = () => setPopover(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "arrowDown",
      iconSide: "right",
      onClick: togglePopover,
      fill: fill
    }, menuButtonLabel),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "crawl all domains",
      onClick: () => {
        closePopover();
        startCrawl();
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.startCrawlContextMenu.crawlAllDomainsMenuLabel', {
      defaultMessage: 'Crawl all domains on this engine'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "crawl select domains",
      onClick: () => {
        closePopover();
        showCrawlSelectDomainsModal();
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.startCrawlContextMenu.crawlSelectDomainsMenuLabel', {
      defaultMessage: 'Crawl select domains'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "crawl with custom settings",
      onClick: () => {
        closePopover();
        showCrawlCustomSettingsFlyout();
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.startCrawlContextMenu.crawlCustomSettingsMenuLabel', {
      defaultMessage: 'Crawl with custom settings'
    }))]
  }));
};
exports.StartCrawlContextMenu = StartCrawlContextMenu;