"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddAnalyticsCollectionModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _add_analytics_collection_form = require("./add_analytics_collection_form");
var _add_analytics_collection_logic = require("./add_analytics_collection_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const collectionNameField = 'collection-name';
const minModalWidth = 400;
const AddAnalyticsCollectionModal = ({
  onClose
}) => {
  const {
    isLoading,
    isSuccess,
    isSystemError,
    canSubmit
  } = (0, _kea.useValues)(_add_analytics_collection_logic.AddAnalyticsCollectionLogic);
  const modalFormId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'createAnalyticsCollection'
  });
  (0, _react.useEffect)(() => {
    if (isSuccess || isSystemError) {
      onClose();
    }
  }, [isSuccess, isSystemError]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    maxWidth: minModalWidth,
    initialFocus: `[name=${collectionNameField}]`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsCreate.form.title', {
    defaultMessage: 'Name your Collection'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsCreate.form.subtitle', {
    defaultMessage: "Consider carefully what you want to name your Collection. You can't rename it later."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_add_analytics_collection_form.AddAnalyticsCollectionForm, {
    formId: modalFormId,
    collectionNameField: collectionNameField
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsCreate.form.cancelButton', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    form: modalFormId,
    iconType: "plusInCircle",
    isLoading: isLoading,
    isDisabled: !canSubmit
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsCreate.form.createButton', {
    defaultMessage: 'Create'
  }))));
};
exports.AddAnalyticsCollectionModal = AddAnalyticsCollectionModal;