"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContactCardEmbeddable = exports.CONTACT_USER_TRIGGER = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _embeddables = require("../../../embeddables");
var _contact_card_embeddable_factory = require("./contact_card_embeddable_factory");
var _contact_card = require("./contact_card");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getFullName(input) {
  const {
    nameTitle,
    firstName,
    lastName
  } = input;
  const nameParts = [nameTitle, firstName, lastName].filter(name => name !== undefined);
  return nameParts.join(' ');
}
class ContactCardEmbeddable extends _embeddables.Embeddable {
  constructor(initialInput, options, parent) {
    super(initialInput, {
      fullName: getFullName(initialInput),
      originalLastName: initialInput.lastName,
      defaultTitle: `Hello ${getFullName(initialInput)}`
    }, parent);
    (0, _defineProperty2.default)(this, "subscription", void 0);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "type", _contact_card_embeddable_factory.CONTACT_CARD_EMBEDDABLE);
    this.options = options;
    this.subscription = this.getInput$().subscribe(() => {
      const fullName = getFullName(this.input);
      this.updateOutput({
        fullName,
        defaultTitle: `Hello ${fullName}`
      });
    });
  }
  render(node) {
    this.node = node;
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_contact_card.ContactCardEmbeddableComponent, {
      embeddable: this,
      execTrigger: this.options.execAction
    }), node);
  }
  catchError(error, node) {
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "error"
    }, error.message), node);
    return () => _reactDom.default.unmountComponentAtNode(node);
  }
  destroy() {
    super.destroy();
    this.subscription.unsubscribe();
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
  }
  reload() {}
  triggerError(error, fatal = false) {
    if (fatal) {
      this.onFatalError(error);
    } else {
      this.updateOutput({
        error
      });
    }
  }
}
exports.ContactCardEmbeddable = ContactCardEmbeddable;
const CONTACT_USER_TRIGGER = 'CONTACT_USER_TRIGGER';
exports.CONTACT_USER_TRIGGER = CONTACT_USER_TRIGGER;