"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContactCardEmbeddableComponent = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var Rx = _interopRequireWildcard(require("rxjs"));
var _contact_card_embeddable = require("./contact_card_embeddable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ContactCardEmbeddableComponent extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "subscription", void 0);
    (0, _defineProperty2.default)(this, "mounted", false);
    (0, _defineProperty2.default)(this, "emitContactTrigger", () => {
      this.props.execTrigger(_contact_card_embeddable.CONTACT_USER_TRIGGER, {
        embeddable: this.props.embeddable
      });
    });
    (0, _defineProperty2.default)(this, "getCardFooterContent", () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: ""
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.emitContactTrigger
    }, `Contact ${this.state.firstName}`)))));
    this.state = {
      fullName: this.props.embeddable.getOutput().fullName,
      firstName: this.props.embeddable.getInput().firstName
    };
  }
  componentDidMount() {
    this.mounted = true;
    this.subscription = Rx.merge(this.props.embeddable.getOutput$(), this.props.embeddable.getInput$()).subscribe(() => {
      if (this.mounted) {
        this.setState({
          fullName: this.props.embeddable.getOutput().fullName,
          firstName: this.props.embeddable.getInput().firstName
        });
      }
    });
  }
  componentWillUnmount() {
    if (this.subscription) {
      this.subscription.unsubscribe();
    }
    this.mounted = false;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      textAlign: "left",
      title: this.state.fullName,
      footer: this.getCardFooterContent(),
      description: ""
    });
  }
}
exports.ContactCardEmbeddableComponent = ContactCardEmbeddableComponent;