"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemovePanelAction = exports.REMOVE_PANEL_ACTION = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _ui_actions = require("../../../ui_actions");
var _types = require("../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const REMOVE_PANEL_ACTION = 'deletePanel';
exports.REMOVE_PANEL_ACTION = REMOVE_PANEL_ACTION;
class RemovePanelAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", REMOVE_PANEL_ACTION);
    (0, _defineProperty2.default)(this, "id", REMOVE_PANEL_ACTION);
    (0, _defineProperty2.default)(this, "order", 1);
  }
  getDisplayName() {
    return _i18n.i18n.translate('embeddableApi.panel.removePanel.displayName', {
      defaultMessage: 'Delete from dashboard'
    });
  }
  getIconType() {
    return 'trash';
  }
  async isCompatible({
    embeddable
  }) {
    var _embeddable$parent, _embeddable$parent$ge;
    const isPanelExpanded =
    // TODO - we need a common embeddable extension pattern to allow actions to call methods on generic embeddables
    // Casting to a type that has the method will do for now.
    ((_embeddable$parent = embeddable.parent) === null || _embeddable$parent === void 0 ? void 0 : (_embeddable$parent$ge = _embeddable$parent.getExpandedPanelId) === null || _embeddable$parent$ge === void 0 ? void 0 : _embeddable$parent$ge.call(_embeddable$parent)) === embeddable.id;
    return Boolean(embeddable.parent && embeddable.getInput().viewMode === _types.ViewMode.EDIT && !isPanelExpanded);
  }
  async execute({
    embeddable
  }) {
    if (!embeddable.parent || !(await this.isCompatible({
      embeddable
    }))) {
      throw new _ui_actions.IncompatibleActionError();
    }
    embeddable.parent.removeEmbeddable(embeddable.id);
  }
}
exports.RemovePanelAction = RemovePanelAction;