"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddPanelAction = exports.ACTION_ADD_PANEL = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _types = require("../../../../types");
var _open_add_panel_flyout = require("./open_add_panel_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_ADD_PANEL = 'ACTION_ADD_PANEL';
exports.ACTION_ADD_PANEL = ACTION_ADD_PANEL;
class AddPanelAction {
  constructor(getFactory, getAllFactories, overlays, notifications, SavedObjectFinder, theme, reportUiCounter) {
    (0, _defineProperty2.default)(this, "type", ACTION_ADD_PANEL);
    (0, _defineProperty2.default)(this, "id", ACTION_ADD_PANEL);
    this.getFactory = getFactory;
    this.getAllFactories = getAllFactories;
    this.overlays = overlays;
    this.notifications = notifications;
    this.SavedObjectFinder = SavedObjectFinder;
    this.theme = theme;
    this.reportUiCounter = reportUiCounter;
  }
  getDisplayName() {
    return _i18n.i18n.translate('embeddableApi.addPanel.displayName', {
      defaultMessage: 'Add panel'
    });
  }
  getIconType() {
    return 'plusInCircleFilled';
  }
  async isCompatible(context) {
    const {
      embeddable
    } = context;
    return embeddable.getIsContainer() && embeddable.getInput().viewMode === _types.ViewMode.EDIT;
  }
  async execute(context) {
    const {
      embeddable
    } = context;
    if (!embeddable.getIsContainer() || !(await this.isCompatible(context))) {
      throw new Error('Context is incompatible');
    }
    (0, _open_add_panel_flyout.openAddPanelFlyout)({
      embeddable,
      getFactory: this.getFactory,
      getAllFactories: this.getAllFactories,
      overlays: this.overlays,
      notifications: this.notifications,
      SavedObjectFinder: this.SavedObjectFinder,
      reportUiCounter: this.reportUiCounter,
      theme: this.theme
    });
  }
}
exports.AddPanelAction = AddPanelAction;