"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildDataTableRecord = buildDataTableRecord;
exports.buildDataTableRecordList = buildDataTableRecordList;
var _common = require("@kbn/data-plugin/common");
var _get_doc_id = require("./get_doc_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Build a record for data table, explorer + classic one
 * @param doc the document returned from Elasticsearch
 * @param dataView this current data view
 * @param isAnchor determines if the given doc is the anchor doc when viewing surrounding documents
 */
function buildDataTableRecord(doc, dataView, isAnchor) {
  return {
    id: (0, _get_doc_id.getDocId)(doc),
    raw: doc,
    flattened: (0, _common.flattenHit)(doc, dataView, {
      includeIgnoredValues: true
    }),
    isAnchor
  };
}

/**
 * Helper to build multiple DataTableRecords at once, saved a bit of testing code lines
 * @param docs Array of documents returned from Elasticsearch
 * @param dataView this current data view
 */
function buildDataTableRecordList(docs, dataView) {
  return docs.map(doc => buildDataTableRecord(doc, dataView));
}