"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocViewerLegacyTable = void 0;
require("../table.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-field-list-plugin/public");
var _use_discover_services = require("../../../../../hooks/use_discover_services");
var _common = require("../../../../../../common");
var _table_columns = require("./table_columns");
var _get_should_show_field_handler = require("../../../../../utils/get_should_show_field_handler");
var _get_ignored_reason = require("../../../../../utils/get_ignored_reason");
var _format_value = require("../../../../../utils/format_value");
var _nested_fields = require("../../../../../application/main/utils/nested_fields");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DocViewerLegacyTable = ({
  columns,
  hit,
  dataView,
  filter,
  onAddColumn,
  onRemoveColumn
}) => {
  const {
    fieldFormats,
    uiSettings
  } = (0, _use_discover_services.useDiscoverServices)();
  const showMultiFields = (0, _react.useMemo)(() => uiSettings.get(_common.SHOW_MULTIFIELDS), [uiSettings]);
  const mapping = (0, _react.useCallback)(name => dataView.fields.getByName(name), [dataView.fields]);
  const tableColumns = (0, _react.useMemo)(() => {
    return filter ? [_table_columns.ACTIONS_COLUMN, ..._table_columns.MAIN_COLUMNS] : _table_columns.MAIN_COLUMNS;
  }, [filter]);
  const onToggleColumn = (0, _react.useCallback)(field => {
    if (!onRemoveColumn || !onAddColumn || !columns) {
      return;
    }
    if (columns.includes(field)) {
      onRemoveColumn(field);
    } else {
      onAddColumn(field);
    }
  }, [onRemoveColumn, onAddColumn, columns]);
  const onSetRowProps = (0, _react.useCallback)(({
    field: {
      field
    }
  }) => {
    return {
      key: field,
      className: 'kbnDocViewer__tableRow',
      'data-test-subj': `tableDocViewRow-${field}`
    };
  }, []);
  const shouldShowFieldHandler = (0, _react.useMemo)(() => (0, _get_should_show_field_handler.getShouldShowFieldHandler)(Object.keys(hit.flattened), dataView, showMultiFields), [hit.flattened, dataView, showMultiFields]);
  const items = Object.keys(hit.flattened).filter(shouldShowFieldHandler).sort((fieldA, fieldB) => {
    const mappingA = mapping(fieldA);
    const mappingB = mapping(fieldB);
    const nameA = !mappingA || !mappingA.displayName ? fieldA : mappingA.displayName;
    const nameB = !mappingB || !mappingB.displayName ? fieldB : mappingB.displayName;
    return nameA.localeCompare(nameB);
  }).map(field => {
    var _fieldMapping$display;
    const fieldMapping = mapping(field);
    const displayName = (_fieldMapping$display = fieldMapping === null || fieldMapping === void 0 ? void 0 : fieldMapping.displayName) !== null && _fieldMapping$display !== void 0 ? _fieldMapping$display : field;
    const fieldType = (0, _nested_fields.isNestedFieldParent)(field, dataView) ? 'nested' : fieldMapping ? (0, _public.getFieldIconType)(fieldMapping) : undefined;
    const ignored = (0, _get_ignored_reason.getIgnoredReason)(fieldMapping !== null && fieldMapping !== void 0 ? fieldMapping : field, hit.raw._ignored);
    return {
      action: {
        onToggleColumn,
        onFilter: filter,
        isActive: !!(columns !== null && columns !== void 0 && columns.includes(field)),
        flattenedField: hit.flattened[field]
      },
      field: {
        field,
        displayName,
        fieldMapping,
        fieldType,
        scripted: Boolean(fieldMapping === null || fieldMapping === void 0 ? void 0 : fieldMapping.scripted)
      },
      value: {
        formattedValue: (0, _format_value.formatFieldValue)(hit.flattened[field], hit.raw, fieldFormats, dataView, fieldMapping),
        ignored
      }
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableLayout: "auto",
    className: "kbnDocViewer__table",
    items: items,
    columns: tableColumns,
    rowProps: onSetRowProps,
    pagination: false,
    responsive: false
  });
};
exports.DocViewerLegacyTable = DocViewerLegacyTable;