"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showConfirmPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let isOpenConfirmPanel = false;
const showConfirmPanel = ({
  onConfirm,
  onCancel
}) => {
  if (isOpenConfirmPanel) {
    return;
  }
  isOpenConfirmPanel = true;
  const container = document.createElement('div');
  const onClose = () => {
    _reactDom.default.unmountComponentAtNode(container);
    document.body.removeChild(container);
    isOpenConfirmPanel = false;
  };
  document.body.appendChild(container);
  const element = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('discover.confirmDataViewSave.title', {
      defaultMessage: 'Save data view'
    }),
    onCancel: () => {
      onClose();
      onCancel();
    },
    onConfirm: () => {
      onClose();
      onConfirm();
    },
    cancelButtonText: _i18n.i18n.translate('discover.confirmDataViewSave.cancel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('discover.confirmDataViewSave.saveAndContinue', {
      defaultMessage: 'Save and continue'
    }),
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('discover.confirmDataViewSave.message', {
    defaultMessage: 'The action you chose requires a saved data view.'
  })));
  _reactDom.default.render(element, container);
};
exports.showConfirmPanel = showConfirmPanel;