"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewSavedSearchAction = exports.ACTION_VIEW_SAVED_SEARCH = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/saved-search-plugin/public");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_VIEW_SAVED_SEARCH = 'ACTION_VIEW_SAVED_SEARCH';
exports.ACTION_VIEW_SAVED_SEARCH = ACTION_VIEW_SAVED_SEARCH;
class ViewSavedSearchAction {
  constructor(application) {
    (0, _defineProperty2.default)(this, "id", ACTION_VIEW_SAVED_SEARCH);
    (0, _defineProperty2.default)(this, "type", ACTION_VIEW_SAVED_SEARCH);
    this.application = application;
  }
  async execute(context) {
    const {
      embeddable
    } = context;
    const savedSearchId = embeddable.getSavedSearch().id;
    const path = (0, _public2.getSavedSearchUrl)(savedSearchId);
    const app = embeddable ? embeddable.getOutput().editApp : undefined;
    await this.application.navigateToApp(app ? app : 'discover', {
      path
    });
  }
  getDisplayName(context) {
    return _i18n.i18n.translate('discover.savedSearchEmbeddable.action.viewSavedSearch.displayName', {
      defaultMessage: 'Open in Discover'
    });
  }
  getIconType(context) {
    return 'inspect';
  }
  async isCompatible(context) {
    const {
      embeddable
    } = context;
    const {
      capabilities
    } = this.application;
    const hasDiscoverPermissions = capabilities.discover.show || capabilities.discover.save;
    return Boolean(embeddable.type === _common.SEARCH_EMBEDDABLE_TYPE && embeddable.getInput().viewMode === _public.ViewMode.VIEW && hasDiscoverPermissions);
  }
}
exports.ViewSavedSearchAction = ViewSavedSearchAction;