"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedSearchEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _esQuery = require("@kbn/es-query");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireWildcard(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/embeddable-plugin/public");
var _common = require("@kbn/inspector-plugin/common");
var _public2 = require("@kbn/data-plugin/public");
var _public3 = require("@kbn/kibana-react-plugin/public");
var _analytics = require("@kbn/analytics");
var _constants = require("../../common/constants");
var _sorting = require("../utils/sorting");
var _build_data_record = require("../utils/build_data_record");
var _constants2 = require("./constants");
var _saved_search_embeddable_component = require("./saved_search_embeddable_component");
var _common2 = require("../../common");
var columnActions = _interopRequireWildcard(require("../components/doc_table/actions/columns"));
var _state_helpers = require("../utils/state_helpers");
var _update_search_source = require("./utils/update_search_source");
var _field_stats_table = require("../application/main/components/field_stats_table");
var _is_text_based_query = require("../application/main/utils/is_text_based_query");
var _get_valid_view_mode = require("../application/main/utils/get_valid_view_mode");
var _fetch_sql = require("../application/main/utils/fetch_sql");
var _constants3 = require("../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SavedSearchEmbeddable extends _public.Embeddable {
  constructor({
    savedSearch: _savedSearch,
    editUrl,
    editPath,
    indexPatterns,
    editable,
    filterManager,
    services
  }, initialInput, executeTriggerActions, parent) {
    var _savedSearch$title;
    super(initialInput, {
      defaultTitle: _savedSearch.title,
      defaultDescription: _savedSearch.description,
      editUrl,
      editPath,
      editApp: 'discover',
      indexPatterns,
      editable
    }, parent);
    (0, _defineProperty2.default)(this, "savedSearch", void 0);
    (0, _defineProperty2.default)(this, "inspectorAdapters", void 0);
    (0, _defineProperty2.default)(this, "panelTitle", '');
    (0, _defineProperty2.default)(this, "filtersSearchSource", void 0);
    (0, _defineProperty2.default)(this, "subscription", void 0);
    (0, _defineProperty2.default)(this, "type", _constants2.SEARCH_EMBEDDABLE_TYPE);
    (0, _defineProperty2.default)(this, "filterManager", void 0);
    (0, _defineProperty2.default)(this, "abortController", void 0);
    (0, _defineProperty2.default)(this, "services", void 0);
    (0, _defineProperty2.default)(this, "prevTimeRange", void 0);
    (0, _defineProperty2.default)(this, "prevFilters", void 0);
    (0, _defineProperty2.default)(this, "prevQuery", void 0);
    (0, _defineProperty2.default)(this, "prevSort", void 0);
    (0, _defineProperty2.default)(this, "prevSearchSessionId", void 0);
    (0, _defineProperty2.default)(this, "searchProps", void 0);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "isTextBasedSearch", savedSearch => {
      const query = savedSearch.searchSource.getField('query');
      return (0, _is_text_based_query.isTextBasedQuery)(query);
    });
    (0, _defineProperty2.default)(this, "fetch", async () => {
      const searchSessionId = this.input.searchSessionId;
      const useNewFieldsApi = !this.services.uiSettings.get(_common2.SEARCH_FIELDS_FROM_SOURCE, false);
      if (!this.searchProps) return;
      const {
        searchSource
      } = this.savedSearch;

      // Abort any in-progress requests
      if (this.abortController) this.abortController.abort();
      const currentAbortController = new AbortController();
      this.abortController = currentAbortController;
      (0, _update_search_source.updateSearchSource)(searchSource, this.searchProps.dataView, this.searchProps.sort, useNewFieldsApi, {
        sampleSize: this.services.uiSettings.get(_common2.SAMPLE_SIZE_SETTING),
        defaultSort: this.services.uiSettings.get(_common2.SORT_DEFAULT_ORDER_SETTING)
      });

      // Log request to inspector
      this.inspectorAdapters.requests.reset();
      this.searchProps.isLoading = true;
      const wasAlreadyRendered = this.getOutput().rendered;
      this.updateOutput({
        ...this.getOutput(),
        loading: true,
        rendered: false,
        error: undefined
      });
      if (wasAlreadyRendered && this.node) {
        // to show a loading indicator during a refetch, we need to rerender here
        this.render(this.node);
      }
      const parentContext = this.input.executionContext;
      const child = {
        type: this.type,
        name: 'discover',
        id: this.savedSearch.id,
        description: this.output.title || this.output.defaultTitle || '',
        url: this.output.editUrl
      };
      const executionContext = parentContext ? {
        ...parentContext,
        child
      } : child;
      const query = this.savedSearch.searchSource.getField('query');
      const dataView = this.savedSearch.searchSource.getField('index');
      const useSql = this.isTextBasedSearch(this.savedSearch);
      try {
        // Request SQL data
        if (useSql && query) {
          const result = await (0, _fetch_sql.fetchSql)(this.savedSearch.searchSource.getField('query'), dataView, this.services.data, this.services.expressions, this.services.inspector, this.input.filters, this.input.query);
          this.updateOutput({
            ...this.getOutput(),
            loading: false
          });
          this.searchProps.rows = result.records;
          this.searchProps.totalHitCount = result.records.length;
          this.searchProps.isLoading = false;
          this.searchProps.isPlainRecord = true;
          this.searchProps.showTimeCol = false;
          this.searchProps.isSortEnabled = true;
          return;
        }

        // Request document data
        const {
          rawResponse: resp
        } = await (0, _rxjs.lastValueFrom)(searchSource.fetch$({
          abortSignal: currentAbortController.signal,
          sessionId: searchSessionId,
          inspector: {
            adapter: this.inspectorAdapters.requests,
            title: _i18n.i18n.translate('discover.embeddable.inspectorRequestDataTitle', {
              defaultMessage: 'Data'
            }),
            description: _i18n.i18n.translate('discover.embeddable.inspectorRequestDescription', {
              defaultMessage: 'This request queries Elasticsearch to fetch the data for the search.'
            })
          },
          executionContext
        }));
        this.updateOutput({
          ...this.getOutput(),
          loading: false
        });
        this.searchProps.rows = resp.hits.hits.map(hit => (0, _build_data_record.buildDataTableRecord)(hit, this.searchProps.dataView));
        this.searchProps.totalHitCount = resp.hits.total;
        this.searchProps.isLoading = false;
      } catch (error) {
        const cancelled = !!(currentAbortController !== null && currentAbortController !== void 0 && currentAbortController.signal.aborted);
        if (!this.destroyed && !cancelled) {
          this.updateOutput({
            ...this.getOutput(),
            loading: false,
            error
          });
          this.searchProps.isLoading = false;
        }
      }
    });
    this.executeTriggerActions = executeTriggerActions;
    this.services = services;
    this.filterManager = filterManager;
    this.savedSearch = _savedSearch;
    this.inspectorAdapters = {
      requests: new _common.RequestAdapter()
    };
    this.panelTitle = this.input.title ? this.input.title : (_savedSearch$title = _savedSearch.title) !== null && _savedSearch$title !== void 0 ? _savedSearch$title : '';
    this.initializeSearchEmbeddableProps();
    this.subscription = this.getUpdated$().subscribe(() => {
      const titleChanged = this.output.title && this.panelTitle !== this.output.title;
      if (titleChanged) {
        this.panelTitle = this.output.title || '';
      }
      if (!this.searchProps) {
        return;
      }
      const isFetchRequired = this.isFetchRequired(this.searchProps);
      const isRerenderRequired = this.isRerenderRequired(this.searchProps);
      if (titleChanged || isFetchRequired || isRerenderRequired) {
        this.reload(isFetchRequired);
      }
    });
  }
  reportsEmbeddableLoad() {
    return true;
  }
  getSort(sort, dataView) {
    return (0, _sorting.getSortForEmbeddable)(sort, dataView, this.services.uiSettings);
  }
  initializeSearchEmbeddableProps() {
    const {
      searchSource
    } = this.savedSearch;
    const dataView = searchSource.getField('index');
    if (!dataView) {
      return;
    }
    const sort = this.getSort(this.savedSearch.sort, dataView);
    if (!dataView.isPersisted()) {
      var _this$services$trackU, _this$services;
      // one used adhoc data view
      (_this$services$trackU = (_this$services = this.services).trackUiMetric) === null || _this$services$trackU === void 0 ? void 0 : _this$services$trackU.call(_this$services, _analytics.METRIC_TYPE.COUNT, _constants3.ADHOC_DATA_VIEW_RENDER_EVENT);
    }
    const props = {
      columns: this.savedSearch.columns,
      savedSearchId: this.savedSearch.id,
      filters: this.savedSearch.searchSource.getField('filter'),
      dataView,
      isLoading: false,
      sort,
      rows: [],
      searchDescription: this.savedSearch.description,
      description: this.savedSearch.description,
      inspectorAdapters: this.inspectorAdapters,
      searchTitle: this.savedSearch.title,
      services: this.services,
      onAddColumn: columnName => {
        if (!props.columns) {
          return;
        }
        const updatedColumns = columnActions.addColumn(props.columns, columnName, true);
        this.updateInput({
          columns: updatedColumns
        });
      },
      onRemoveColumn: columnName => {
        if (!props.columns) {
          return;
        }
        const updatedColumns = columnActions.removeColumn(props.columns, columnName, true);
        this.updateInput({
          columns: updatedColumns
        });
      },
      onMoveColumn: (columnName, newIndex) => {
        if (!props.columns) {
          return;
        }
        const columns = columnActions.moveColumn(props.columns, columnName, newIndex);
        this.updateInput({
          columns
        });
      },
      onSetColumns: columns => {
        this.updateInput({
          columns
        });
      },
      onSort: nextSort => {
        const sortOrderArr = [];
        nextSort.forEach(arr => {
          sortOrderArr.push(arr);
        });
        this.updateInput({
          sort: sortOrderArr
        });
      },
      sampleSize: this.services.uiSettings.get(_common2.SAMPLE_SIZE_SETTING),
      onFilter: async (field, value, operator) => {
        let filters = (0, _public2.generateFilters)(this.filterManager,
        // @ts-expect-error
        field, value, operator, dataView);
        filters = filters.map(filter => ({
          ...filter,
          $state: {
            store: _esQuery.FilterStateStore.APP_STATE
          }
        }));
        await this.executeTriggerActions(_public2.APPLY_FILTER_TRIGGER, {
          embeddable: this,
          filters
        });
      },
      useNewFieldsApi: !this.services.uiSettings.get(_common2.SEARCH_FIELDS_FROM_SOURCE, false),
      showTimeCol: !this.services.uiSettings.get(_common2.DOC_HIDE_TIME_COLUMN_SETTING, false),
      ariaLabelledBy: 'documentsAriaLabel',
      rowHeightState: this.input.rowHeight || this.savedSearch.rowHeight,
      onUpdateRowHeight: rowHeight => {
        this.updateInput({
          rowHeight
        });
      },
      rowsPerPageState: this.input.rowsPerPage || this.savedSearch.rowsPerPage,
      onUpdateRowsPerPage: rowsPerPage => {
        this.updateInput({
          rowsPerPage
        });
      }
    };
    const timeRangeSearchSource = searchSource.create();
    timeRangeSearchSource.setField('filter', () => {
      const timeRange = this.getTimeRange();
      if (!this.searchProps || !timeRange) return;
      return this.services.timefilter.createFilter(dataView, timeRange);
    });
    this.filtersSearchSource = searchSource.create();
    this.filtersSearchSource.setParent(timeRangeSearchSource);
    searchSource.setParent(this.filtersSearchSource);
    this.load(props);
    props.isLoading = true;
    if (this.savedSearch.grid) {
      props.settings = this.savedSearch.grid;
    }
  }
  getTimeRange() {
    return this.input.timeslice !== undefined ? {
      from: new Date(this.input.timeslice[0]).toISOString(),
      to: new Date(this.input.timeslice[1]).toISOString(),
      mode: 'absolute'
    } : this.input.timeRange;
  }
  isFetchRequired(searchProps) {
    if (!searchProps || !searchProps.dataView) {
      return false;
    }
    return !(0, _esQuery.onlyDisabledFiltersChanged)(this.input.filters, this.prevFilters) || !(0, _lodash.isEqual)(this.prevQuery, this.input.query) || !(0, _lodash.isEqual)(this.prevTimeRange, this.getTimeRange()) || !(0, _lodash.isEqual)(this.prevSort, this.input.sort) || this.prevSearchSessionId !== this.input.searchSessionId;
  }
  isRerenderRequired(searchProps) {
    if (!searchProps) {
      return false;
    }
    return this.input.rowsPerPage !== searchProps.rowsPerPageState || this.input.columns && !(0, _lodash.isEqual)(this.input.columns, searchProps.columns);
  }
  async pushContainerStateParamsToProps(searchProps, {
    forceFetch = false
  } = {
    forceFetch: false
  }) {
    const isFetchRequired = this.isFetchRequired(searchProps);

    // If there is column or sort data on the panel, that means the original columns or sort settings have
    // been overridden in a dashboard.
    searchProps.columns = (0, _state_helpers.handleSourceColumnState)({
      columns: this.input.columns || this.savedSearch.columns
    }, this.services.core.uiSettings).columns;
    searchProps.sort = this.getSort(this.input.sort || this.savedSearch.sort, searchProps === null || searchProps === void 0 ? void 0 : searchProps.dataView);
    searchProps.sharedItemTitle = this.panelTitle;
    searchProps.searchTitle = this.panelTitle;
    searchProps.rowHeightState = this.input.rowHeight || this.savedSearch.rowHeight;
    searchProps.rowsPerPageState = this.input.rowsPerPage || this.savedSearch.rowsPerPage;
    searchProps.filters = this.savedSearch.searchSource.getField('filter');
    searchProps.savedSearchId = this.savedSearch.id;
    if (forceFetch || isFetchRequired) {
      var _this$input$query, _this$input$filters;
      this.filtersSearchSource.setField('filter', this.input.filters);
      this.filtersSearchSource.setField('query', this.input.query);
      if ((_this$input$query = this.input.query) !== null && _this$input$query !== void 0 && _this$input$query.query || (_this$input$filters = this.input.filters) !== null && _this$input$filters !== void 0 && _this$input$filters.length) {
        this.filtersSearchSource.setField('highlightAll', true);
      } else {
        this.filtersSearchSource.removeField('highlightAll');
      }
      this.prevFilters = this.input.filters;
      this.prevQuery = this.input.query;
      this.prevTimeRange = this.getTimeRange();
      this.prevSearchSessionId = this.input.searchSessionId;
      this.prevSort = this.input.sort;
      this.searchProps = searchProps;
      await this.fetch();
    } else if (this.searchProps && this.node) {
      this.searchProps = searchProps;
    }
  }

  /**
   *
   * @param {Element} domNode
   */
  async render(domNode) {
    if (!this.searchProps) {
      throw new Error('Search props not defined');
    }
    super.render(domNode);
    this.node = domNode;
    this.renderReactComponent(this.node, this.searchProps);
  }
  renderReactComponent(domNode, searchProps) {
    if (!searchProps) {
      return;
    }
    const viewMode = (0, _get_valid_view_mode.getValidViewMode)({
      viewMode: this.savedSearch.viewMode,
      isTextBasedQueryMode: this.isTextBasedSearch(this.savedSearch)
    });
    if (this.services.uiSettings.get(_common2.SHOW_FIELD_STATISTICS) === true && viewMode === _constants.VIEW_MODE.AGGREGATED_LEVEL && searchProps.services && searchProps.dataView && Array.isArray(searchProps.columns)) {
      _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public3.KibanaThemeProvider, {
        theme$: searchProps.services.core.theme.theme$
      }, /*#__PURE__*/_react.default.createElement(_public3.KibanaContextProvider, {
        services: searchProps.services
      }, /*#__PURE__*/_react.default.createElement(_field_stats_table.FieldStatisticsTable, {
        dataView: searchProps.dataView,
        columns: searchProps.columns,
        savedSearch: this.savedSearch,
        filters: this.input.filters,
        query: this.input.query,
        onAddFilter: searchProps.onFilter,
        searchSessionId: this.input.searchSessionId
      })))), domNode);
      this.updateOutput({
        ...this.getOutput(),
        rendered: true
      });
      return;
    }
    const useLegacyTable = this.services.uiSettings.get(_common2.DOC_TABLE_LEGACY);
    const query = this.savedSearch.searchSource.getField('query');
    const props = {
      savedSearch: this.savedSearch,
      searchProps,
      useLegacyTable,
      query
    };
    if (searchProps.services) {
      _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public3.KibanaThemeProvider, {
        theme$: searchProps.services.core.theme.theme$
      }, /*#__PURE__*/_react.default.createElement(_public3.KibanaContextProvider, {
        services: searchProps.services
      }, /*#__PURE__*/_react.default.createElement(_saved_search_embeddable_component.SavedSearchEmbeddableComponent, props)))), domNode);
      const hasError = this.getOutput().error !== undefined;
      if (this.searchProps.isLoading === false && props.searchProps.rows !== undefined) {
        this.renderComplete.dispatchComplete();
        this.updateOutput({
          ...this.getOutput(),
          rendered: true
        });
      } else if (hasError) {
        this.renderComplete.dispatchError();
        this.updateOutput({
          ...this.getOutput(),
          rendered: true
        });
      }
    }
  }
  async load(searchProps, forceFetch = false) {
    await this.pushContainerStateParamsToProps(searchProps, {
      forceFetch
    });
    if (this.node) {
      this.render(this.node);
    }
  }
  reload(forceFetch = true) {
    if (this.searchProps) {
      this.load(this.searchProps, forceFetch);
    }
  }
  getSavedSearch() {
    return this.savedSearch;
  }
  getInspectorAdapters() {
    return this.inspectorAdapters;
  }

  /**
   * @returns Local/panel-level array of filters for Saved Search embeddable
   */
  async getFilters() {
    var _ref;
    return (0, _public2.mapAndFlattenFilters)((_ref = this.savedSearch.searchSource.getFields().filter) !== null && _ref !== void 0 ? _ref : []);
  }

  /**
   * @returns Local/panel-level query for Saved Search embeddable
   */
  async getQuery() {
    return this.savedSearch.searchSource.getFields().query;
  }
  destroy() {
    var _this$subscription;
    super.destroy();
    if (this.searchProps) {
      delete this.searchProps;
    }
    if (this.node) {
      (0, _reactDom.unmountComponentAtNode)(this.node);
    }
    (_this$subscription = this.subscription) === null || _this$subscription === void 0 ? void 0 : _this$subscription.unsubscribe();
    if (this.abortController) this.abortController.abort();
  }
}
exports.SavedSearchEmbeddable = SavedSearchEmbeddable;