"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfileAwareLocator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _customizations = require("../../common/customizations");
var _kibana_services = require("../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ProfileAwareLocator {
  constructor(locator) {
    (0, _defineProperty2.default)(this, "id", void 0);
    (0, _defineProperty2.default)(this, "migrations", void 0);
    this.locator = locator;
    this.id = locator.id;
    this.migrations = locator.migrations;
  }
  injectProfile(params) {
    if (params.profile) {
      return params;
    }
    const history = (0, _kibana_services.getHistory)();
    const {
      profile
    } = (0, _customizations.getProfile)(history.location.pathname);
    if (profile) {
      params = {
        ...params,
        profile
      };
    }
    return params;
  }
  getLocation(params) {
    return this.locator.getLocation(this.injectProfile(params));
  }
  getUrl(params, getUrlParams) {
    return this.locator.getUrl(this.injectProfile(params), getUrlParams);
  }
  getRedirectUrl(params, options) {
    return this.locator.getRedirectUrl(this.injectProfile(params), options);
  }
  navigate(params, navigationParams) {
    return this.locator.navigate(this.injectProfile(params), navigationParams);
  }
  navigateSync(params, navigationParams) {
    return this.locator.navigateSync(this.injectProfile(params), navigationParams);
  }
  useUrl(params, getUrlParams, deps) {
    return this.locator.useUrl(this.injectProfile(params), getUrlParams, deps);
  }
  telemetry(state, stats) {
    return this.locator.telemetry(this.injectProfile(state), stats);
  }
  inject(state, references) {
    return this.locator.inject(this.injectProfile(state), references);
  }
  extract(state) {
    return this.locator.extract(this.injectProfile(state));
  }
}
exports.ProfileAwareLocator = ProfileAwareLocator;