"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildCopyColumnNameButton = buildCopyColumnNameButton;
exports.buildCopyColumnValuesButton = buildCopyColumnValuesButton;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _copy_value_to_clipboard = require("../../utils/copy_value_to_clipboard");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function buildCopyColumnButton({
  label,
  onCopy,
  dataTestSubj
}) {
  const copyToClipBoardButton = {
    size: 'xs',
    label,
    iconType: 'copyClipboard',
    iconProps: {
      size: 'm'
    },
    onClick: onCopy,
    'data-test-subj': dataTestSubj
  };
  return copyToClipBoardButton;
}
function buildCopyColumnNameButton({
  columnDisplayName,
  toastNotifications
}) {
  return buildCopyColumnButton({
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.grid.copyColumnNameToClipBoardButton",
      defaultMessage: "Copy name"
    }),
    onCopy: () => (0, _copy_value_to_clipboard.copyColumnNameToClipboard)({
      columnDisplayName,
      toastNotifications
    }),
    dataTestSubj: 'gridCopyColumnNameToClipBoardButton'
  });
}
function buildCopyColumnValuesButton({
  columnId,
  columnDisplayName,
  toastNotifications,
  rowsCount,
  valueToStringConverter
}) {
  return buildCopyColumnButton({
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.grid.copyColumnValuesToClipBoardButton",
      defaultMessage: "Copy column"
    }),
    onCopy: () => (0, _copy_value_to_clipboard.copyColumnValuesToClipboard)({
      columnId,
      columnDisplayName,
      toastNotifications,
      rowsCount,
      valueToStringConverter
    }),
    dataTestSubj: 'gridCopyColumnValuesToClipBoardButton'
  });
}