"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeferredSpinner = void 0;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * A component that shows it children with a 300ms delay. This is good for wrapping
 * loading spinners for tasks that might potentially be very fast (e.g. loading async chunks).
 * That way we don't show a quick flash of the spinner before the actual content and will only
 * show the spinner once loading takes a bit longer (more than 300ms).
 */
const DeferredSpinner = ({
  children
}) => {
  const timeoutRef = (0, _react.useRef)();
  const [showContent, setShowContent] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    timeoutRef.current = window.setTimeout(() => {
      setShowContent(true);
    }, 300);
    return () => {
      if (timeoutRef.current) {
        clearTimeout(timeoutRef.current);
      }
    };
  }, []);
  return showContent ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children) : null;
};
exports.DeferredSpinner = DeferredSpinner;